/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.engine.search.SiteAwareElasticsearchService;
import org.elasticsearch.action.search.SearchResponse;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/elasticsearch"})
public class SiteElasticsearchController
extends RestControllerBase {
    public static final String URL_ROOT = "/site/elasticsearch";
    public static final String URL_SEARCH = "/search";
    protected SiteAwareElasticsearchService elasticsearchService;

    @Required
    public void setElasticsearchService(SiteAwareElasticsearchService elasticsearchService) {
        this.elasticsearchService = elasticsearchService;
    }

    @PostMapping(value={"/search"})
    public void search(@RequestBody Map<String, Object> request, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        SearchResponse searchResponse = this.elasticsearchService.search(request);
        response.getWriter().write(searchResponse.toString());
    }
}

