/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.engine.graphql.QueryRequest;
import org.craftercms.engine.service.context.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/graphql"})
public class SiteGraphQLController
extends RestControllerBase {
    private static final Logger logger = LoggerFactory.getLogger(SiteGraphQLController.class);
    public static final String BASE_URL = "/site/graphql";
    protected ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping
    public Map<String, Object> query(@RequestParam String query, @RequestParam(required=false) String operationName, @RequestParam(required=false) String variablesStr) throws IOException {
        Map variables = StringUtils.isEmpty((Object)variablesStr) ? Collections.emptyMap() : (Map)this.objectMapper.readValue(variablesStr, Map.class);
        return this.handleRequest(query, operationName, variables);
    }

    @PostMapping
    public Map<String, Object> query(@RequestBody QueryRequest request) {
        Map<String, Object> variables = Objects.isNull(request.getVariables()) ? Collections.emptyMap() : request.getVariables();
        return this.handleRequest(request.getQuery(), request.getOperationName(), variables);
    }

    protected Map<String, Object> handleRequest(String query, String operationName, Map<String, Object> variables) {
        SiteContext siteContext = SiteContext.getCurrent();
        RequestContext requestContext = RequestContext.getCurrent();
        GraphQL graphQL = siteContext.getGraphQL();
        if (Objects.isNull(graphQL)) {
            logger.warn("GraphQL schema has not been initialized for site {}", (Object)siteContext.getSiteName());
            return Collections.singletonMap("errors", Collections.singletonList(Collections.singletonMap("message", "GraphQL schema has not been initialized for site " + siteContext.getSiteName())));
        }
        ExecutionInput.Builder executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(variables).context((Object)requestContext);
        StopWatch watch = new StopWatch("graphql - " + operationName);
        watch.start("query");
        ExecutionResult result = graphQL.execute(executionInput);
        watch.stop();
        if (logger.isTraceEnabled()) {
            logger.trace(watch.prettyPrint());
        }
        return result.toSpecification();
    }
}

