/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest.preview;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/profile"})
public class ProfileRestController {
    public static final String URL_ROOT = "/profile";
    public static final String PROFILE_SESSION_ATTRIBUTE = "_cr_profile_state";
    public static final String CLEANSE_ATTRS_CONFIG_KEY = "preview.targeting.cleanseAttributes";

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public Map<String, String> getProfile(HttpSession session) {
        HashMap profile = (HashMap)session.getAttribute(PROFILE_SESSION_ATTRIBUTE);
        if (profile == null) {
            profile = new HashMap();
            session.setAttribute(PROFILE_SESSION_ATTRIBUTE, profile);
        }
        return profile;
    }

    @RequestMapping(value={"/set"}, method={RequestMethod.GET})
    public Map<String, String> setProfile(HttpServletRequest request, HttpSession session) {
        boolean cleanseAttributes = this.shouldCleanseAttributes();
        HashMap<String, String> profile = new HashMap<String, String>();
        Enumeration paramNamesEnum = request.getParameterNames();
        while (paramNamesEnum.hasMoreElements()) {
            String paramName = (String)paramNamesEnum.nextElement();
            String paramValue = request.getParameter(paramName);
            if (!StringUtils.isNotEmpty((CharSequence)paramValue)) continue;
            String value = paramValue.trim();
            profile.put(paramName, cleanseAttributes ? StringEscapeUtils.escapeHtml4((String)value) : value);
        }
        profile.put("id", new ObjectId().toHexString());
        session.setAttribute(PROFILE_SESSION_ATTRIBUTE, profile);
        return profile;
    }

    protected boolean shouldCleanseAttributes() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        return siteConfig != null && siteConfig.getBoolean(CLEANSE_ATTRS_CONFIG_KEY, true);
    }
}

