/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.entitlement;

import java.util.Collections;
import java.util.List;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.usage.EntitlementUsageProvider;
import org.craftercms.engine.service.context.SiteContextManager;
import org.springframework.beans.factory.annotation.Required;

public class EngineEntitlementUsageProvider
implements EntitlementUsageProvider {
    protected SiteContextManager siteContextManager;

    @Required
    public void setSiteContextManager(SiteContextManager siteContextManager) {
        this.siteContextManager = siteContextManager;
    }

    public Module getModule() {
        return Module.ENGINE;
    }

    public List<EntitlementType> getSupportedEntitlements() {
        return Collections.singletonList(EntitlementType.SITE);
    }

    public int doGetEntitlementUsage(EntitlementType type) {
        return (int)this.siteContextManager.listContexts().stream().filter(context -> !context.isFallback()).count();
    }
}

