/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;

public class CrafterFreeMarkerTemplateLoader
implements TemplateLoader {
    private static final Log logger = LogFactory.getLog(CrafterFreeMarkerTemplateLoader.class);
    private ContentStoreService contentStoreService;
    private String[] globalAllowedPaths;

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    @Required
    public void setGlobalAllowedPaths(String[] globalAllowedPaths) {
        this.globalAllowedPaths = globalAllowedPaths;
    }

    public Object findTemplateSource(String name) throws IOException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            Content content;
            String path = this.getTemplatePath(siteContext, name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for FreeMarker template at [context=" + siteContext + ", path='" + path + "']"));
            }
            if ((content = this.contentStoreService.findContent(siteContext.getContext(), path)) == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find FreeMarker template at [context=" + siteContext + ", path='" + path + "']"));
            }
            return content;
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((Content)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new InputStreamReader(((Content)templateSource).getInputStream(), encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    protected String getTemplatePath(SiteContext siteContext, String name) {
        String templatesPath = siteContext.getTemplatesPath();
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)StringUtils.removeStart((String)templatesPath, (String)"/")) || RegexUtils.matchesAny((String)name, (String[])this.globalAllowedPaths) || RegexUtils.matchesAny((String)name, (String[])siteContext.getAllowedTemplatePaths())) {
            return name;
        }
        return UrlUtils.concat((String)templatesPath, (String)name);
    }
}

