/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.craftercms.engine.model.Dom4jNodeModel;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.util.ContentModelUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;

public class CrafterObjectWrapper
extends DefaultObjectWrapper {
    protected final boolean enableSandbox;

    public CrafterObjectWrapper(boolean enableSandbox) {
        this.enableSandbox = enableSandbox;
    }

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj instanceof Element && !SiteProperties.isDisableFullModelTypeConversion()) {
            Object result = ContentModelUtils.convertField((Element)obj);
            if (result instanceof Node) {
                return new Dom4jNodeModel((Node)obj, (ObjectWrapper)this);
            }
            return super.wrap(result);
        }
        if (obj instanceof Node) {
            return new Dom4jNodeModel((Node)obj, (ObjectWrapper)this);
        }
        return super.wrap(obj);
    }

    protected TemplateModel invokeMethod(Object object, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, TemplateModelException {
        boolean blocked;
        if (this.enableSandbox && (blocked = Modifier.isStatic(method.getModifiers()) ? StaticWhitelist.isPermanentlyBlacklistedStaticMethod((Method)method) : StaticWhitelist.isPermanentlyBlacklistedMethod((Method)method))) {
            return null;
        }
        return super.invokeMethod(object, method, args);
    }
}

