/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.SiteItemScriptResolver;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.dom4j.Element;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;

public class RenderComponentDirective
implements TemplateDirectiveModel {
    private static final Log logger = LogFactory.getLog(RenderComponentDirective.class);
    @Deprecated
    public static final String KEY_MODEL = "model";
    public static final String KEY_CONTENT_MODEL = "contentModel";
    public static final String COMPONENT_PARENT_PARAM_NAME = "parent";
    public static final String COMPONENT_PARAM_NAME = "component";
    public static final String COMPONENT_PATH_PARAM_NAME = "componentPath";
    public static final String ADDITIONAL_MODEL_PARAM_NAME = "additionalModel";
    protected ServletContext servletContext;
    protected SiteItemService siteItemService;
    protected ObjectFactory<SimpleHash> modelFactory;
    protected String templateXPathQuery;
    protected String templateNamePrefix;
    protected String templateNameSuffix;
    protected String includeElementName;
    protected String componentElementName;
    protected SiteItemScriptResolver scriptResolver;

    @Required
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setModelFactory(ObjectFactory<SimpleHash> modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Required
    public void setTemplateXPathQuery(String templateXPathQuery) {
        this.templateXPathQuery = templateXPathQuery;
    }

    @Required
    public void setTemplateNamePrefix(String templateNamePrefix) {
        this.templateNamePrefix = templateNamePrefix;
    }

    @Required
    public void setTemplateNameSuffix(String templateNameSuffix) {
        this.templateNameSuffix = templateNameSuffix;
    }

    @Required
    public void setIncludeElementName(String includeElementName) {
        this.includeElementName = includeElementName;
    }

    @Required
    public void setComponentElementName(String componentElementName) {
        this.componentElementName = componentElementName;
    }

    @Required
    public void setScriptResolver(SiteItemScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException {
        TemplateModel componentParentParam = (TemplateModel)params.get(COMPONENT_PARENT_PARAM_NAME);
        TemplateModel componentParam = (TemplateModel)params.get(COMPONENT_PARAM_NAME);
        TemplateModel componentPathParam = (TemplateModel)params.get(COMPONENT_PATH_PARAM_NAME);
        TemplateModel additionalModelParam = (TemplateModel)params.get(ADDITIONAL_MODEL_PARAM_NAME);
        Map additionalModel = null;
        if (componentParam == null && componentPathParam == null) {
            throw new TemplateException("No 'component' or 'componentPath' param specified", env);
        }
        SiteItem component = componentParam != null ? this.getComponentFromNode(componentParentParam, componentParam, env) : this.getComponentFromPath(componentPathParam, env);
        if (additionalModelParam != null) {
            additionalModel = this.unwrap(ADDITIONAL_MODEL_PARAM_NAME, additionalModelParam, Map.class, env);
        }
        Map<String, Object> templateModel = this.executeScripts(component, additionalModel, env);
        SimpleHash model = this.getFullModel(component, templateModel, additionalModel);
        Template template = this.getTemplate(component, env);
        Writer output = env.getOut();
        this.processComponentTemplate(template, model, output, env);
    }

    protected SiteItem getComponentFromNode(TemplateModel parentParam, TemplateModel componentParam, Environment env) throws TemplateException {
        SiteItem parentItem = this.unwrap(COMPONENT_PARENT_PARAM_NAME, parentParam, SiteItem.class, env);
        Element includeElementParent = this.unwrap(COMPONENT_PARAM_NAME, componentParam, Element.class, env);
        Element includeElement = includeElementParent.element(this.includeElementName);
        Element componentElement = includeElementParent.element(this.componentElementName);
        if (includeElement != null) {
            logger.debug((Object)"Using the include element to load the site item");
            String componentPath = includeElement.getTextTrim();
            return this.getComponent(componentPath, env);
        }
        if (componentElement != null) {
            logger.debug((Object)"Using an embedded site item");
            if (parentItem == null) {
                logger.debug((Object)"Using default parent component");
                parentItem = this.unwrap(KEY_CONTENT_MODEL, env.getVariable(KEY_CONTENT_MODEL), SiteItem.class, env);
            }
            return this.siteItemService.getSiteItem(parentItem, componentElement);
        }
        throw new IllegalStateException("No '" + this.includeElementName + "' or '" + this.componentElementName + "' element found under component " + includeElementParent.getUniquePath());
    }

    protected SiteItem getComponentFromPath(TemplateModel componentPathParam, Environment env) throws TemplateException {
        String componentPath = this.unwrap(COMPONENT_PATH_PARAM_NAME, componentPathParam, String.class, env);
        return this.getComponent(componentPath, env);
    }

    protected SiteItem getComponent(String componentPath, Environment env) throws TemplateException {
        SiteItem component;
        SiteItem currentPage = this.unwrap(KEY_CONTENT_MODEL, env.getVariable(KEY_CONTENT_MODEL), SiteItem.class, env);
        if (currentPage != null) {
            String basePath = FilenameUtils.getFullPath((String)currentPage.getStoreUrl());
            URI baseUri = URI.create(basePath);
            try {
                componentPath = baseUri.resolve(componentPath).toString();
            }
            catch (IllegalArgumentException e) {
                throw new TemplateException("Invalid relative component URL " + componentPath, (Exception)e, env);
            }
        }
        try {
            component = this.siteItemService.getSiteItem(componentPath);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to load component " + componentPath + " from the underlying repository", e, env);
        }
        if (component == null) {
            throw new TemplateException("No component found at path '" + componentPath + "'", env);
        }
        return component;
    }

    protected Map<String, Object> executeScripts(SiteItem component, Map<String, Object> additionalModel, Environment env) throws TemplateException {
        List<String> scriptUrls = this.scriptResolver.getScriptUrls(component);
        if (CollectionUtils.isNotEmpty(scriptUrls)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Scripts associated to component " + component.getStoreUrl() + ": " + scriptUrls));
            }
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            Map<String, Object> scriptVariables = this.createScriptVariables(component, templateModel, additionalModel);
            SiteContext siteContext = SiteContext.getCurrent();
            if (siteContext != null) {
                ScriptFactory scriptFactory = siteContext.getScriptFactory();
                if (scriptFactory == null) {
                    throw new IllegalStateException("No script factory associate to current site context '" + siteContext.getSiteName() + "'");
                }
                for (String scriptUrl : scriptUrls) {
                    Script script;
                    try {
                        script = scriptFactory.getScript(scriptUrl);
                    }
                    catch (Exception e) {
                        throw new TemplateException("Unable to load script at '" + scriptUrl + "'", e, env);
                    }
                    this.executeScript(script, scriptVariables, env);
                }
            } else {
                throw new IllegalStateException("No current site context found");
            }
            return templateModel;
        }
        return null;
    }

    protected Map<String, Object> createScriptVariables(SiteItem component, Map<String, Object> templateModel, Map<String, Object> additionalModel) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            GroovyScriptUtils.addSiteItemScriptVariables(variables, context.getRequest(), context.getResponse(), this.servletContext, component, templateModel);
            if (MapUtils.isNotEmpty(additionalModel)) {
                variables.putAll(additionalModel);
            }
        } else {
            throw new IllegalStateException("No current request context found");
        }
        return variables;
    }

    protected void executeScript(Script script, Map<String, Object> scriptVariables, Environment env) throws TemplateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing component script at " + script.getUrl()));
        }
        try {
            script.execute(scriptVariables);
        }
        catch (Exception e) {
            throw new TemplateException("Error executing component script at " + script.getUrl(), e, env);
        }
    }

    protected Template getTemplate(SiteItem component, Environment env) throws TemplateException {
        try {
            return env.getTemplateForInclusion(this.getComponentTemplateName(component, env), null, true);
        }
        catch (IOException e) {
            throw new TemplateException("Unable to retrieve component template", (Exception)e, env);
        }
    }

    protected String getComponentTemplateName(SiteItem component, Environment env) throws TemplateException {
        String componentTemplateName = component.queryValue(this.templateXPathQuery);
        if (StringUtils.isNotEmpty((CharSequence)componentTemplateName)) {
            return this.templateNamePrefix + componentTemplateName + this.templateNameSuffix;
        }
        throw new TemplateException("No component template defined in " + component, env);
    }

    protected SimpleHash getFullModel(SiteItem component, Map<String, Object> templateModel, Map<String, Object> additionalModel) throws TemplateException {
        SimpleHash model = (SimpleHash)this.modelFactory.getObject();
        model.put(KEY_MODEL, (Object)component);
        model.put(KEY_CONTENT_MODEL, (Object)component);
        if (MapUtils.isNotEmpty(templateModel)) {
            model.putAll(templateModel);
        }
        if (MapUtils.isNotEmpty(additionalModel)) {
            model.putAll(additionalModel);
        }
        return model;
    }

    protected void processComponentTemplate(Template template, SimpleHash model, Writer output, Environment env) throws TemplateException {
        try {
            template.process((Object)model, output);
        }
        catch (IOException e) {
            throw new TemplateException("I/O exception while processing the component template", (Exception)e, env);
        }
    }

    protected <T> T unwrap(String name, TemplateModel value, Class<T> expectedClass, Environment env) throws TemplateException {
        if (value != null) {
            Object unwrappedValue = DeepUnwrap.unwrap((TemplateModel)value);
            try {
                return expectedClass.cast(unwrappedValue);
            }
            catch (ClassCastException e) {
                throw new TemplateException("Model value '" + name + "' of unexpected type: expected: " + expectedClass.getName() + ", actual: " + unwrappedValue.getClass().getName(), env);
            }
        }
        return null;
    }
}

