/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

public abstract class SchemaUtils {
    public static final String ARG_NAME_SORT_BY = "sortBy";
    public static final String ARG_NAME_SORT_ORDER = "sortOrder";
    public static final String ARG_NAME_OFFSET = "offset";
    public static final String ARG_NAME_LIMIT = "limit";
    public static final String ARG_NAME_EQUALS = "equals";
    public static final String ARG_NAME_MATCHES = "matches";
    public static final String ARG_NAME_REGEX = "regex";
    public static final String ARG_NAME_LT = "lt";
    public static final String ARG_NAME_GT = "gt";
    public static final String ARG_NAME_LTE = "lte";
    public static final String ARG_NAME_GTE = "gte";
    public static final String ARG_NAME_EXISTS = "exists";
    public static final String ARG_NAME_NOT = "not";
    public static final String ARG_NAME_OR = "or";
    public static final String ARG_NAME_AND = "and";
    public static final String ARG_NAME_TRANSFORM = "transform";
    public static final String STRING_FILTER_NAME = "StringFilters";
    public static final String TEXT_FILTER_NAME = "TextFilters";
    public static final String BOOLEAN_FILTER_NAME = "BooleanFilters";
    public static final String INT_FILTER_NAME = "IntFilters";
    public static final String FLOAT_FILTER_NAME = "FloatFilters";
    public static final String LONG_FILTER_NAME = "LongFilters";
    public static final String DATETIME_FILTER_NAME = "DateFilters";
    public static final String FIELD_SEPARATOR = "_";
    public static final String FIELD_NAME_CONTENT_ITEMS = "contentItems";
    public static final String FIELD_NAME_PAGES = "pages";
    public static final String FIELD_NAME_COMPONENTS = "components";
    public static final String FIELD_NAME_CONTENT_TYPE = SchemaUtils.getGraphQLName("content-type");
    public static final String FIELD_NAME_ITEM = "item";
    public static final String FIELD_NAME_ITEMS = "items";
    public static final String FIELD_NAME_TOTAL = "total";
    public static final String FIELD_NAME_KEY = "key";
    public static final String FIELD_NAME_VALUE = "value";
    public static final String FIELD_NAME_SELECTED = "selected";
    public static final String FIELD_NAME_COMPONENT = "component";
    public static final String FIELD_SUFFIX_ITEM = "_item";
    public static final String FIELD_SUFFIX_ITEMS = "_items";
    public static final String FIELD_SUFFIX_QUERY = "_query";
    public static final String FIELD_SUFFIX_RAW = "_raw";
    public static final String FIELD_SUFFIX_TZ = "_tz";
    public static final String FIELD_SUFFIX_TOKENIZED = "_t";
    public static final String FIELD_SUFFIX_MULTIVALUE = "mv";
    public static final String FILTER_NAME = "filter";
    public static final String FILTER_DESCRIPTION = "Values used to filter the results";
    public static final GraphQLEnumType ORDER_ENUM = GraphQLEnumType.newEnum().name("SortOrder").description("Possible values for sorting").value("ASC").value("DESC").build();
    public static final List<GraphQLArgument> TYPE_ARGUMENTS = Arrays.asList(GraphQLArgument.newArgument().name("sortBy").description("The name of the field to sort items").type((GraphQLInputType)Scalars.GraphQLString).build(), GraphQLArgument.newArgument().name("sortOrder").description("The order to sort items").type((GraphQLInputType)ORDER_ENUM).build(), GraphQLArgument.newArgument().name("offset").description("The number of items to skip").type((GraphQLInputType)Scalars.GraphQLInt).build(), GraphQLArgument.newArgument().name("limit").description("The number of items to return").type((GraphQLInputType)Scalars.GraphQLInt).build());
    public static final GraphQLArgument TRANSFORM_ARG = GraphQLArgument.newArgument().name("transform").description("The name of the transformer to apply").type((GraphQLInputType)Scalars.GraphQLString).build();
    public static final GraphQLArgument STRING_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("StringFilters").description("Filters for 'string' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("equals").description("Search for exact matches").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("regex").description("Search for a regex").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"StringFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"StringFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"StringFilters"))))).build()).build();
    public static final GraphQLArgument TEXT_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("TextFilters").description("Filters for 'text' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("matches").description("Search for terms in the text").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("regex").description("Search for a regex").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"TextFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"TextFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"TextFilters"))))).build()).build();
    public static final GraphQLArgument BOOLEAN_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("BooleanFilters").description("Filters applicable for 'boolean' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("equals").description("Search for the given value").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"BooleanFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"BooleanFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"BooleanFilters"))))).build()).build();
    public static final GraphQLArgument INT_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("IntFilters").description("Filters applicable for 'int' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("equals").description("Search for the given value").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("lt").description("Search for values less than the given value").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("gt").description("Search for values greater than the given value").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("gte").description("Search for values greater than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("lte").description("Search for values less than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"IntFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"IntFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"IntFilters"))))).build()).build();
    public static final GraphQLArgument FLOAT_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("FloatFilters").description("Filters applicable for 'float' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("equals").description("Search for the given value").type((GraphQLInputType)Scalars.GraphQLFloat)).field(GraphQLInputObjectField.newInputObjectField().name("lt").description("Search for values less than the given value").type((GraphQLInputType)Scalars.GraphQLFloat)).field(GraphQLInputObjectField.newInputObjectField().name("gt").description("Search for values greater than the given value").type((GraphQLInputType)Scalars.GraphQLFloat)).field(GraphQLInputObjectField.newInputObjectField().name("gte").description("Search for values greater than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLFloat)).field(GraphQLInputObjectField.newInputObjectField().name("lte").description("Search for values less than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLFloat)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"FloatFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"FloatFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"FloatFilters"))))).build()).build();
    public static final GraphQLArgument LONG_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("LongFilters").description("Filters applicable for 'long' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("equals").description("Search for the given value").type((GraphQLInputType)Scalars.GraphQLLong)).field(GraphQLInputObjectField.newInputObjectField().name("lt").description("Search for values less than the given value").type((GraphQLInputType)Scalars.GraphQLLong)).field(GraphQLInputObjectField.newInputObjectField().name("gt").description("Search for values greater than the given value").type((GraphQLInputType)Scalars.GraphQLLong)).field(GraphQLInputObjectField.newInputObjectField().name("gte").description("Search for values greater than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLLong)).field(GraphQLInputObjectField.newInputObjectField().name("lte").description("Search for values less than or equal to the given value").type((GraphQLInputType)Scalars.GraphQLLong)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"LongFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"LongFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"LongFilters"))))).build()).build();
    public static final GraphQLArgument DATETIME_FILTER = GraphQLArgument.newArgument().name("filter").description("Values used to filter the results").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("DateFilters").description("Filters applicable for 'datetime' fields").field(GraphQLInputObjectField.newInputObjectField().name("exists").description("Search if field exists or not (a field exists if it has a non-null value)").type((GraphQLInputType)Scalars.GraphQLBoolean)).field(GraphQLInputObjectField.newInputObjectField().name("lt").description("Search for values less than the given value").type((GraphQLInputType)ExtendedScalars.DateTime)).field(GraphQLInputObjectField.newInputObjectField().name("gt").description("Search for values greater than the given value").type((GraphQLInputType)ExtendedScalars.DateTime)).field(GraphQLInputObjectField.newInputObjectField().name("gte").description("Search for values greater than or equal to the given value").type((GraphQLInputType)ExtendedScalars.DateTime)).field(GraphQLInputObjectField.newInputObjectField().name("lte").description("Search for values less than or equal to the given value").type((GraphQLInputType)ExtendedScalars.DateTime)).field(GraphQLInputObjectField.newInputObjectField().name("not").description("Combines the list of filters using the NOT operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"DateFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("or").description("Combines the list of filters using the OR operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"DateFilters"))))).field(GraphQLInputObjectField.newInputObjectField().name("and").description("Combines the list of filters using the AND operator").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"DateFilters"))))).build()).build();
    public static final List<GraphQLFieldDefinition> CONTENT_ITEM_FIELDS = Arrays.asList(GraphQLFieldDefinition.newFieldDefinition().name(FIELD_NAME_CONTENT_TYPE).description("The content type of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(STRING_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("internal-name")).description("The name/label of the item in Authoring (can also be used as a navigation label in Delivery)").type((GraphQLOutputType)Scalars.GraphQLString).argument(STRING_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("localId")).description("The path of the item").type((GraphQLOutputType)Scalars.GraphQLString).arguments(Arrays.asList(TRANSFORM_ARG, STRING_FILTER)).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("objectId")).description("The objectId of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(STRING_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("objectGroupId")).description("The objectGroupId for the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(STRING_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("createdDate_dt")).description("The created date of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)ExtendedScalars.DateTime)).argument(DATETIME_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("lastModifiedDate_dt")).description("The last modified date of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)ExtendedScalars.DateTime)).argument(DATETIME_FILTER).build());
    public static final List<GraphQLFieldDefinition> PAGE_FIELDS = Arrays.asList(GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("placeInNav")).description("If the page should be placed in the navigation").type((GraphQLOutputType)Scalars.GraphQLBoolean).argument(BOOLEAN_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("orderDefault_f")).description("The order the page has in the navigation").type((GraphQLOutputType)Scalars.GraphQLFloat).argument(FLOAT_FILTER).build(), GraphQLFieldDefinition.newFieldDefinition().name(SchemaUtils.getGraphQLName("navLabel")).description("The label of the page in the navigation").type((GraphQLOutputType)Scalars.GraphQLString).argument(STRING_FILTER).build());
    public static final GraphQLInterfaceType CONTENT_ITEM_INTERFACE_TYPE = GraphQLInterfaceType.newInterface().name("ContentItem").description("Interface for all content items (pages, components and taxonomies)").fields(CONTENT_ITEM_FIELDS).build();
    public static final GraphQLInterfaceType PAGE_INTERFACE_TYPE = GraphQLInterfaceType.newInterface().name("Page").description("Interface for pages").fields(ListUtils.union(CONTENT_ITEM_FIELDS, PAGE_FIELDS)).build();
    public static final GraphQLObjectType ITEM_INCLUDE_TYPE = GraphQLObjectType.newObject().name("ItemInclude").description("Holds a reference to another item in the site").field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("The name of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(TEXT_FILTER)).field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("The path of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(TEXT_FILTER)).build();
    public static final GraphQLObjectType ITEM_INCLUDE_WRAPPER_TYPE = GraphQLObjectType.newObject().name("ItemIncludeWrapper").description("Wrapper for a list of item references").field(GraphQLFieldDefinition.newFieldDefinition().name("item").description("List of item references").type((GraphQLOutputType)GraphQLList.list((GraphQLType)ITEM_INCLUDE_TYPE))).build();
    public static final GraphQLObjectType CONTENT_INCLUDE_TYPE = GraphQLObjectType.newObject().name("ContentInclude").description("Holds the content of another item in the site").field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("The name of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(TEXT_FILTER)).field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("The path of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).argument(TEXT_FILTER)).field(GraphQLFieldDefinition.newFieldDefinition().name("component").description("The content of the item").type((GraphQLOutputType)CONTENT_ITEM_INTERFACE_TYPE)).build();
    public static final GraphQLObjectType CONTENT_INCLUDE_WRAPPER_TYPE = GraphQLObjectType.newObject().name("ContentIncludeWrapper").description("Wrapper for a list of flattened components").field(GraphQLFieldDefinition.newFieldDefinition().name("item").description("List of items").type((GraphQLOutputType)GraphQLList.list((GraphQLType)CONTENT_INCLUDE_TYPE))).build();
    public static final TypeResolver CONTENT_TYPE_BASED_TYPE_RESOLVER = env -> {
        Object contentType;
        Object item = env.getObject();
        if (item instanceof Map && (contentType = ((Map)item).get(FIELD_NAME_CONTENT_TYPE)) != null) {
            return env.getSchema().getObjectType(SchemaUtils.getGraphQLName(contentType.toString()));
        }
        return null;
    };

    public static String getGraphQLName(String name) {
        return name.replaceAll("-", "__").replaceAll("^/page/", "page_").replaceAll("^/component/", "component_").replaceAll("^/taxonomy", "taxonomy").replaceAll("/", "___");
    }

    public static String getOriginalName(String graphQLName) {
        return graphQLName.replaceAll("^page_", "/page/").replaceAll("^component_", "/component/").replaceAll("^taxonomy", "/taxonomy").replaceAll("___", "/").replaceAll("__", "-");
    }

    public static void setTypeFromFieldName(String fieldName, GraphQLFieldDefinition.Builder field) {
        if (fieldName.endsWith("_s")) {
            field.type((GraphQLOutputType)Scalars.GraphQLString);
            field.argument(STRING_FILTER);
        } else if (fieldName.endsWith("_dt") || fieldName.endsWith("_to")) {
            field.type((GraphQLOutputType)ExtendedScalars.DateTime);
            field.argument(DATETIME_FILTER);
        } else if (fieldName.endsWith("_b")) {
            field.type((GraphQLOutputType)Scalars.GraphQLBoolean);
            field.argument(BOOLEAN_FILTER);
        } else if (fieldName.endsWith("_i")) {
            field.type((GraphQLOutputType)Scalars.GraphQLInt);
            field.argument(INT_FILTER);
        } else if (fieldName.endsWith("_f") || fieldName.endsWith("_d")) {
            field.type((GraphQLOutputType)Scalars.GraphQLFloat);
            field.argument(FLOAT_FILTER);
        } else if (fieldName.endsWith("_l")) {
            field.type((GraphQLOutputType)Scalars.GraphQLLong);
            field.argument(LONG_FILTER);
        } else {
            field.type((GraphQLOutputType)Scalars.GraphQLString);
            field.argument(TEXT_FILTER);
        }
    }

    public static GraphQLType createQueryWrapperType(String namePrefix, String description) {
        return GraphQLObjectType.newObject().name(namePrefix + FIELD_SUFFIX_QUERY).description(description).field(GraphQLFieldDefinition.newFieldDefinition().name(FIELD_NAME_TOTAL).description("Total number of items found").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt))).field(GraphQLFieldDefinition.newFieldDefinition().name(FIELD_NAME_ITEMS).description("List of items").type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)namePrefix))))).build();
    }

    public static GraphQLType createQueryWrapperType(String namePrefix, GraphQLType wrappedType, String description) {
        return GraphQLObjectType.newObject().name(namePrefix + FIELD_SUFFIX_QUERY).description(description).field(GraphQLFieldDefinition.newFieldDefinition().name(FIELD_NAME_TOTAL).description("Total number of items found").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt))).field(GraphQLFieldDefinition.newFieldDefinition().name(FIELD_NAME_ITEMS).description("List of items").type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)wrappedType)))).build();
    }
}

