/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl;

import graphql.GraphQL;
import graphql.schema.AsyncDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.engine.exception.ScriptNotFoundException;
import org.craftercms.engine.graphql.GraphQLFactory;
import org.craftercms.engine.graphql.GraphQLTypeFactory;
import org.craftercms.engine.graphql.SchemaUtils;
import org.craftercms.engine.graphql.impl.SchemaCustomizer;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.craftercms.engine.util.concurrent.SiteAwareThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.StopWatch;
import org.springframework.web.context.ServletContextAware;

public class GraphQLFactoryImpl
implements GraphQLFactory,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLFactory.class);
    public static final String VARIABLE_SCHEMA = "schema";
    protected String schemaScriptPath;
    protected String repoConfigFolder;
    protected String contentTypeDefinitionName;
    protected String rootQueryTypeName;
    protected GraphQLTypeFactory typeFactory;
    protected DataFetcher<?> dataFetcher;
    protected Executor jobThreadPoolExecutor;
    protected ServletContext servletContext;
    protected boolean disableVariableRestrictions;

    @Required
    public void setSchemaScriptPath(String schemaScriptPath) {
        this.schemaScriptPath = schemaScriptPath;
    }

    @Required
    public void setRepoConfigFolder(String repoConfigFolder) {
        this.repoConfigFolder = repoConfigFolder;
    }

    @Required
    public void setContentTypeDefinitionName(String contentTypeDefinitionName) {
        this.contentTypeDefinitionName = contentTypeDefinitionName;
    }

    @Required
    public void setRootQueryTypeName(String rootQueryTypeName) {
        this.rootQueryTypeName = rootQueryTypeName;
    }

    @Required
    public void setTypeFactory(GraphQLTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Required
    public void setDataFetcher(DataFetcher<?> dataFetcher) {
        this.dataFetcher = dataFetcher;
    }

    @Required
    public void setJobThreadPoolExecutor(Executor jobThreadPoolExecutor) {
        this.jobThreadPoolExecutor = jobThreadPoolExecutor;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDisableVariableRestrictions(boolean disableVariableRestrictions) {
        this.disableVariableRestrictions = disableVariableRestrictions;
    }

    protected void findContentTypes(Tree item, GraphQLObjectType.Builder rootType, GraphQLCodeRegistry.Builder codeRegistry, DataFetcher<?> dataFetcher, Map<String, GraphQLObjectType.Builder> siteTypes) {
        logger.debug("Looking for content-type definitions in '{}'", (Object)item.getUrl());
        List children = item.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            Optional<Item> formDefinition = children.stream().filter(i -> this.contentTypeDefinitionName.equals(i.getName())).findFirst();
            if (formDefinition.isPresent()) {
                this.typeFactory.createType(formDefinition.get(), rootType, codeRegistry, dataFetcher, siteTypes);
            } else {
                children.stream().filter(i -> i instanceof Tree).forEach(i -> this.findContentTypes((Tree)i, rootType, codeRegistry, dataFetcher, siteTypes));
            }
        }
    }

    protected GraphQLSchema buildSchema(SiteContext siteContext) {
        logger.debug("Building GraphQL Schema for site '{}'", (Object)siteContext.getSiteName());
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
        GraphQLObjectType.Builder rootType = GraphQLObjectType.newObject().name(this.rootQueryTypeName).description("Provides access to all site content");
        codeRegistry.typeResolver(SchemaUtils.CONTENT_ITEM_INTERFACE_TYPE, SchemaUtils.CONTENT_TYPE_BASED_TYPE_RESOLVER);
        codeRegistry.typeResolver(SchemaUtils.PAGE_INTERFACE_TYPE, SchemaUtils.CONTENT_TYPE_BASED_TYPE_RESOLVER);
        rootType.field(GraphQLFieldDefinition.newFieldDefinition().name("contentItems").description("All content items").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)SchemaUtils.createQueryWrapperType("contentItems", (GraphQLType)SchemaUtils.CONTENT_ITEM_INTERFACE_TYPE, "Query for all content items"))).arguments(SchemaUtils.TYPE_ARGUMENTS));
        rootType.field(GraphQLFieldDefinition.newFieldDefinition().name("pages").description("All pages").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)SchemaUtils.createQueryWrapperType("pages", (GraphQLType)SchemaUtils.PAGE_INTERFACE_TYPE, "Query for all pages"))).arguments(SchemaUtils.TYPE_ARGUMENTS));
        rootType.field(GraphQLFieldDefinition.newFieldDefinition().name("components").description("All components").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)SchemaUtils.createQueryWrapperType("components", (GraphQLType)SchemaUtils.CONTENT_ITEM_INTERFACE_TYPE, "Query for all components"))).arguments(SchemaUtils.TYPE_ARGUMENTS));
        AsyncDataFetcher asyncFetcher = AsyncDataFetcher.async(this.dataFetcher, (Executor)new SiteAwareThreadPoolExecutor(siteContext, this.jobThreadPoolExecutor));
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)this.rootQueryTypeName, (String)"contentItems"), (DataFetcher)asyncFetcher);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)this.rootQueryTypeName, (String)"pages"), (DataFetcher)asyncFetcher);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)this.rootQueryTypeName, (String)"components"), (DataFetcher)asyncFetcher);
        HashMap<String, GraphQLObjectType.Builder> siteTypes = new HashMap<String, GraphQLObjectType.Builder>();
        ContentStoreService storeService = siteContext.getStoreService();
        Tree tree = storeService.findTree(siteContext.getContext(), this.repoConfigFolder);
        if (Objects.nonNull(tree)) {
            this.findContentTypes(tree, rootType, codeRegistry, (DataFetcher<?>)asyncFetcher, (Map<String, GraphQLObjectType.Builder>)siteTypes);
        }
        SchemaCustomizer customizer = new SchemaCustomizer();
        this.runInitScript(siteContext, rootType, codeRegistry, customizer, siteTypes);
        HashSet additionalTypes = new HashSet();
        siteTypes.forEach((name, type) -> additionalTypes.add(type.build()));
        return GraphQLSchema.newSchema().additionalTypes(customizer.getAdditionalTypes()).additionalTypes(additionalTypes).codeRegistry(codeRegistry.build()).query(rootType).build();
    }

    protected void runInitScript(SiteContext siteContext, GraphQLObjectType.Builder rootType, GraphQLCodeRegistry.Builder codeRegistry, SchemaCustomizer customizer, Map<String, GraphQLObjectType.Builder> siteTypes) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GroovyScriptUtils.addJobScriptVariables(variables, this.disableVariableRestrictions ? this.servletContext : null);
        variables.put(VARIABLE_SCHEMA, customizer);
        try {
            siteContext.getScriptFactory().getScript(this.schemaScriptPath).execute(variables);
        }
        catch (ScriptNotFoundException e) {
            logger.info("No custom GraphQL schema found for site '{}'", (Object)siteContext.getSiteName());
        }
        logger.info("Updating GraphQL schema with custom fields, fetchers & resolvers");
        customizer.apply(this.rootQueryTypeName, rootType, codeRegistry, siteTypes);
    }

    @Override
    public GraphQL getInstance(SiteContext siteContext) {
        StopWatch watch = new StopWatch("GraphQL Schema");
        watch.start("Schema Build");
        GraphQLSchema schema = this.buildSchema(siteContext);
        watch.stop();
        if (logger.isTraceEnabled()) {
            logger.trace(watch.prettyPrint());
        }
        return GraphQL.newGraphQL((GraphQLSchema)schema).build();
    }
}

