/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.StaticDataFetcher;
import graphql.schema.TypeResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.graphql.impl.fetchers.ConverterDataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(SchemaCustomizer.class);
    public static final DataFetcher<?> EMPTY_DATA_FETCHER = new StaticDataFetcher(Collections.emptyMap());
    protected List<FieldBuilder> customFields = new LinkedList<FieldBuilder>();
    protected List<FetcherBuilder> fetchers = new LinkedList<FetcherBuilder>();
    protected List<ResolverBuilder> resolvers = new LinkedList<ResolverBuilder>();
    protected List<GraphQLType> additionalTypes = new LinkedList<GraphQLType>();

    public void field(GraphQLFieldDefinition.Builder field, DataFetcher<?> fetcher) {
        this.customFields.add(new FieldBuilder(null, field, fetcher));
    }

    public void field(GraphQLFieldDefinition.Builder field) {
        this.field(field, EMPTY_DATA_FETCHER);
    }

    public void field(String typeName, GraphQLFieldDefinition.Builder field, DataFetcher<?> fetcher) {
        this.customFields.add(new FieldBuilder(typeName, field, fetcher));
    }

    public void field(String typeName, GraphQLFieldDefinition.Builder field) {
        this.field(typeName, field, EMPTY_DATA_FETCHER);
    }

    public void fetcher(String typeName, String fieldName, DataFetcher<?> dataFetcher) {
        this.fetchers.add(new FetcherBuilder(typeName, fieldName, dataFetcher));
    }

    public void resolver(String typeName, TypeResolver resolver) {
        this.resolvers.add(new ResolverBuilder(typeName, resolver));
    }

    public void additionalTypes(GraphQLType ... types) {
        this.additionalTypes.addAll(Arrays.asList(types));
    }

    protected void apply(String rootTypeName, GraphQLObjectType.Builder rootTypeBuilder, GraphQLCodeRegistry.Builder codeRegistry, Map<String, GraphQLObjectType.Builder> types) {
        this.customFields.forEach(builder -> {
            String fieldName = builder.field.build().getName();
            if (StringUtils.isEmpty((CharSequence)builder.typeName)) {
                logger.debug("Adding custom field & fetcher {}", (Object)fieldName);
                if (rootTypeBuilder.hasField(fieldName)) {
                    throw new IllegalArgumentException(String.format("GraphQL schema already contains a field '%s'", fieldName));
                }
                rootTypeBuilder.field(builder.field);
                codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)rootTypeName, (String)fieldName), (DataFetcher)ConverterDataFetcher.of(builder.fetcher));
            } else {
                if (!types.containsKey(builder.typeName)) {
                    throw new IllegalArgumentException(String.format("GraphQL schema does not contain a type '%s'", builder.typeName));
                }
                if (((GraphQLObjectType.Builder)types.get(builder.typeName)).hasField(fieldName)) {
                    throw new IllegalArgumentException(String.format("GraphQL schema already contains a field '%s.%s'", builder.typeName, fieldName));
                }
                logger.debug("Adding custom field & fetcher {}.{}", (Object)builder.typeName, (Object)fieldName);
                ((GraphQLObjectType.Builder)types.get(builder.typeName)).field(builder.field);
                codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)builder.typeName, (String)fieldName), (DataFetcher)ConverterDataFetcher.of(builder.fetcher));
            }
        });
        this.fetchers.forEach(builder -> {
            logger.debug("Adding custom fetcher for {}/{}", (Object)builder.typeName, (Object)builder.fieldName);
            codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)builder.typeName, (String)builder.fieldName), (DataFetcher)ConverterDataFetcher.of(builder.dataFetcher));
        });
        this.resolvers.forEach(builder -> {
            logger.debug("Adding custom resolver for {}", (Object)builder.typeName);
            codeRegistry.typeResolver(builder.typeName, builder.resolver);
        });
    }

    public Set<GraphQLType> getAdditionalTypes() {
        return new HashSet<GraphQLType>(this.additionalTypes);
    }

    private static class ResolverBuilder {
        public final String typeName;
        public final TypeResolver resolver;

        public ResolverBuilder(String typeName, TypeResolver resolver) {
            this.typeName = typeName;
            this.resolver = resolver;
        }
    }

    private static class FetcherBuilder {
        public final String typeName;
        public final String fieldName;
        public final DataFetcher<?> dataFetcher;

        public FetcherBuilder(String typeName, String fieldName, DataFetcher<?> dataFetcher) {
            this.typeName = typeName;
            this.fieldName = fieldName;
            this.dataFetcher = dataFetcher;
        }
    }

    private static class FieldBuilder {
        public final String typeName;
        public final GraphQLFieldDefinition.Builder field;
        public final DataFetcher<?> fetcher;

        public FieldBuilder(String typeName, GraphQLFieldDefinition.Builder field, DataFetcher<?> fetcher) {
            this.typeName = typeName;
            this.field = field;
            this.fetcher = fetcher;
        }
    }
}

