/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.fetchers;

import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Selection;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.graphql.SchemaUtils;
import org.craftercms.engine.graphql.impl.fetchers.RequestAwareDataFetcher;
import org.craftercms.search.elasticsearch.ElasticsearchWrapper;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.StopWatch;

public class ContentTypeBasedDataFetcher
extends RequestAwareDataFetcher<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeBasedDataFetcher.class);
    private static final String QUERY_FIELD_NAME_CONTENT_TYPE = SchemaUtils.getOriginalName(SchemaUtils.FIELD_NAME_CONTENT_TYPE);
    public static final String CONTENT_TYPE_REGEX_PAGE = "/?page/.*";
    public static final String CONTENT_TYPE_REGEX_COMPONENT = "/?component/.*";
    public static final String COMPONENT_INCLUDE_REGEX = ".*\\.item\\.component";
    protected int defaultLimit;
    protected String defaultSortField;
    protected String defaultSortOrder;
    protected ElasticsearchWrapper elasticsearch;

    @Required
    public void setDefaultLimit(int defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    @Required
    public void setDefaultSortField(String defaultSortField) {
        this.defaultSortField = defaultSortField;
    }

    @Required
    public void setDefaultSortOrder(String defaultSortOrder) {
        this.defaultSortOrder = defaultSortOrder;
    }

    @Required
    public void setElasticsearch(ElasticsearchWrapper elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    @Override
    public Object doGet(DataFetchingEnvironment env) {
        Field field = env.getMergedField().getSingleField();
        String fieldName = field.getName();
        int offset = (Integer)Optional.ofNullable(env.getArgument("offset")).orElse(0);
        int limit = (Integer)Optional.ofNullable(env.getArgument("limit")).orElse(this.defaultLimit);
        String sortBy = (String)Optional.ofNullable(env.getArgument("sortBy")).orElse(this.defaultSortField);
        String sortOrder = (String)Optional.ofNullable(env.getArgument("sortOrder")).orElse(this.defaultSortOrder);
        LinkedList<String> queryFieldIncludes = new LinkedList<String>();
        queryFieldIncludes.add(QUERY_FIELD_NAME_CONTENT_TYPE);
        LinkedList<Map<String, Object>> items = new LinkedList<Map<String, Object>>();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(2);
        result.put("items", items);
        SearchSourceBuilder source = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        source.query((QueryBuilder)query).from(offset).size(limit).sort(sortBy, SortOrder.fromString((String)sortOrder));
        StopWatch watch = new StopWatch(field.getName() + " - " + field.getAlias());
        watch.start("build filters");
        switch (fieldName) {
            case "contentItems": {
                query.filter((QueryBuilder)QueryBuilders.existsQuery((String)QUERY_FIELD_NAME_CONTENT_TYPE));
                break;
            }
            case "pages": {
                query.filter((QueryBuilder)QueryBuilders.regexpQuery((String)QUERY_FIELD_NAME_CONTENT_TYPE, (String)CONTENT_TYPE_REGEX_PAGE));
                break;
            }
            case "components": {
                query.filter((QueryBuilder)QueryBuilders.regexpQuery((String)QUERY_FIELD_NAME_CONTENT_TYPE, (String)CONTENT_TYPE_REGEX_COMPONENT));
                break;
            }
            default: {
                query.filter((QueryBuilder)QueryBuilders.termQuery((String)QUERY_FIELD_NAME_CONTENT_TYPE, (String)SchemaUtils.getOriginalName(fieldName)));
            }
        }
        Optional<Field> itemsField = field.getSelectionSet().getSelections().stream().map(f -> (Field)f).filter(f -> f.getName().equals("items")).findFirst();
        if (itemsField.isPresent()) {
            List selections = itemsField.get().getSelectionSet().getSelections();
            selections.forEach(selection -> this.processSelection("", (Selection)selection, query, (List<String>)queryFieldIncludes, env));
        }
        source.fetchSource(queryFieldIncludes.toArray(new String[0]), new String[0]);
        watch.stop();
        logger.debug("Executing query: {}", (Object)source);
        watch.start("searching items");
        SearchResponse response = this.elasticsearch.search(new SearchRequest().source(source));
        watch.stop();
        watch.start("processing items");
        result.put("total", Long.valueOf(response.getHits().totalHits));
        if (response.getHits().totalHits > 0L) {
            for (SearchHit hit : response.getHits().getHits()) {
                items.add(this.fixItems(hit.getSourceAsMap()));
            }
        }
        watch.stop();
        if (logger.isTraceEnabled()) {
            logger.trace(watch.prettyPrint());
        }
        return result;
    }

    protected void processSelection(String path, Selection currentSelection, BoolQueryBuilder query, List<String> queryFieldIncludes, DataFetchingEnvironment env) {
        if (currentSelection instanceof Field) {
            String fullPath;
            Field currentField = (Field)currentSelection;
            String propertyName = SchemaUtils.getOriginalName(currentField.getName());
            String string = fullPath = StringUtils.isEmpty((CharSequence)path) ? propertyName : path + "." + propertyName;
            if (Objects.nonNull(currentField.getSelectionSet())) {
                String contentTypeFieldPath;
                if (fullPath.matches(COMPONENT_INCLUDE_REGEX) && !queryFieldIncludes.contains(contentTypeFieldPath = fullPath + "." + QUERY_FIELD_NAME_CONTENT_TYPE)) {
                    queryFieldIncludes.add(contentTypeFieldPath);
                }
                currentField.getSelectionSet().getSelections().forEach(selection -> this.processSelection(fullPath, (Selection)selection, query, queryFieldIncludes, env));
                return;
            }
            logger.debug("Adding selected field '{}' to query", (Object)fullPath);
            queryFieldIncludes.add(fullPath);
            Optional<Argument> arg = currentField.getArguments().stream().filter(a -> a.getName().equals("filter")).findFirst();
            if (arg.isPresent()) {
                logger.debug("Adding filters for field {}", (Object)fullPath);
                Value argValue = arg.get().getValue();
                if (argValue instanceof ObjectValue) {
                    List filters = ((ObjectValue)argValue).getObjectFields();
                    filters.forEach(filter -> this.addFieldFilterFromObjectField(fullPath, (ObjectField)filter, query, env));
                } else if (argValue instanceof VariableReference && env.getVariables().containsKey(((VariableReference)argValue).getName())) {
                    Map map = (Map)env.getVariables().get(((VariableReference)argValue).getName());
                    map.entrySet().forEach(filter -> this.addFieldFilterFromMapEntry(fullPath, (Map.Entry<String, Object>)filter, query, env));
                }
            }
        } else if (currentSelection instanceof InlineFragment) {
            InlineFragment fragment = (InlineFragment)currentSelection;
            fragment.getSelectionSet().getSelections().forEach(selection -> this.processSelection(path, (Selection)selection, query, queryFieldIncludes, env));
        } else if (currentSelection instanceof FragmentSpread) {
            FragmentSpread fragmentSpread = (FragmentSpread)currentSelection;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)env.getFragmentsByName().get(fragmentSpread.getName());
            fragmentDefinition.getSelectionSet().getSelections().forEach(selection -> this.processSelection(path, (Selection)selection, query, queryFieldIncludes, env));
        }
    }

    protected void addFieldFilterFromObjectField(String path, ObjectField filter, BoolQueryBuilder query, DataFetchingEnvironment env) {
        boolean isVariable = filter.getValue() instanceof VariableReference;
        switch (filter.getName()) {
            case "not": {
                BoolQueryBuilder notQuery = QueryBuilders.boolQuery();
                if (isVariable) {
                    ((List)env.getVariables().get(((VariableReference)filter.getValue()).getName())).forEach(notFilter -> notFilter.entrySet().forEach(entry -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)entry, notQuery, env)));
                } else {
                    ((ArrayValue)filter.getValue()).getValues().forEach(notFilter -> ((ObjectValue)notFilter).getObjectFields().forEach(notField -> this.addFieldFilterFromObjectField(path, (ObjectField)notField, notQuery, env)));
                }
                if (notQuery.filter().isEmpty()) break;
                notQuery.filter().forEach(arg_0 -> ((BoolQueryBuilder)query).mustNot(arg_0));
                break;
            }
            case "and": {
                if (isVariable) {
                    ((List)env.getVariables().get(((VariableReference)filter.getValue()).getName())).forEach(andFilter -> andFilter.entrySet().forEach(entry -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)entry, query, env)));
                    break;
                }
                ((ArrayValue)filter.getValue()).getValues().forEach(andFilter -> ((ObjectValue)andFilter).getObjectFields().forEach(andField -> this.addFieldFilterFromObjectField(path, (ObjectField)andField, query, env)));
                break;
            }
            case "or": {
                BoolQueryBuilder tempQuery = QueryBuilders.boolQuery();
                if (isVariable) {
                    ((List)env.getVariables().get(((VariableReference)filter.getValue()).getName())).forEach(orFilter -> orFilter.entrySet().forEach(entry -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)entry, tempQuery, env)));
                } else {
                    ((ArrayValue)filter.getValue()).getValues().forEach(orFilter -> ((ObjectValue)orFilter).getObjectFields().forEach(orField -> this.addFieldFilterFromObjectField(path, (ObjectField)orField, tempQuery, env)));
                }
                if (tempQuery.filter().isEmpty()) break;
                BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
                tempQuery.filter().forEach(arg_0 -> ((BoolQueryBuilder)orQuery).should(arg_0));
                query.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orQuery));
                break;
            }
            default: {
                QueryBuilder builder = this.getFilterQueryFromObjectField(path, filter, env);
                if (builder == null) break;
                query.filter(builder);
            }
        }
    }

    protected void addFieldFilterFromMapEntry(String path, Map.Entry<String, Object> filter, BoolQueryBuilder query, DataFetchingEnvironment env) {
        if (filter.getValue() instanceof List) {
            List actualFilters = (List)filter.getValue();
            switch (filter.getKey()) {
                case "not": {
                    BoolQueryBuilder notQuery = QueryBuilders.boolQuery();
                    actualFilters.forEach(notFilter -> notFilter.entrySet().forEach(notField -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)notField, notQuery, env)));
                    notQuery.filter().forEach(arg_0 -> ((BoolQueryBuilder)query).mustNot(arg_0));
                    break;
                }
                case "and": {
                    actualFilters.forEach(andFilter -> andFilter.entrySet().forEach(andField -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)andField, query, env)));
                    break;
                }
                case "or": {
                    BoolQueryBuilder tempQuery = QueryBuilders.boolQuery();
                    BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
                    actualFilters.forEach(orFilter -> orFilter.entrySet().forEach(orField -> this.addFieldFilterFromMapEntry(path, (Map.Entry<String, Object>)orField, tempQuery, env)));
                    tempQuery.filter().forEach(arg_0 -> ((BoolQueryBuilder)orQuery).should(arg_0));
                    query.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orQuery));
                    break;
                }
            }
        } else {
            query.filter(this.getFilterQueryFromMapEntry(path, filter));
        }
    }

    protected QueryBuilder getFilterQueryFromObjectField(String fieldPath, ObjectField filter, DataFetchingEnvironment env) {
        Object value = this.getRealValue(filter.getValue(), env);
        if (value == null) {
            return null;
        }
        switch (filter.getName()) {
            case "equals": {
                return QueryBuilders.termQuery((String)fieldPath, (Object)value);
            }
            case "matches": {
                return QueryBuilders.matchQuery((String)fieldPath, (Object)value);
            }
            case "regex": {
                return QueryBuilders.regexpQuery((String)fieldPath, (String)value.toString());
            }
            case "lt": {
                return QueryBuilders.rangeQuery((String)fieldPath).lt(value);
            }
            case "gt": {
                return QueryBuilders.rangeQuery((String)fieldPath).gt(value);
            }
            case "lte": {
                return QueryBuilders.rangeQuery((String)fieldPath).lte(value);
            }
            case "gte": {
                return QueryBuilders.rangeQuery((String)fieldPath).gte(value);
            }
            case "exists": {
                boolean exists = (Boolean)value;
                if (exists) {
                    return QueryBuilders.existsQuery((String)fieldPath);
                }
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)fieldPath));
            }
        }
        return null;
    }

    protected QueryBuilder getFilterQueryFromMapEntry(String fieldPath, Map.Entry<String, Object> filter) {
        switch (filter.getKey()) {
            case "equals": {
                return QueryBuilders.termQuery((String)fieldPath, (Object)filter.getValue());
            }
            case "matches": {
                return QueryBuilders.matchQuery((String)fieldPath, (Object)filter.getValue());
            }
            case "regex": {
                return QueryBuilders.regexpQuery((String)fieldPath, (String)filter.getValue().toString());
            }
            case "lt": {
                return QueryBuilders.rangeQuery((String)fieldPath).lt(filter.getValue());
            }
            case "gt": {
                return QueryBuilders.rangeQuery((String)fieldPath).gt(filter.getValue());
            }
            case "lte": {
                return QueryBuilders.rangeQuery((String)fieldPath).lte(filter.getValue());
            }
            case "gte": {
                return QueryBuilders.rangeQuery((String)fieldPath).gte(filter.getValue());
            }
            case "exists": {
                boolean exists = (Boolean)filter.getValue();
                if (exists) {
                    return QueryBuilders.existsQuery((String)fieldPath);
                }
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)fieldPath));
            }
        }
        return null;
    }

    protected Object getRealValue(Value value, DataFetchingEnvironment env) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof VariableReference) {
            return env.getVariables().get(((VariableReference)value).getName());
        }
        return null;
    }

    protected Map<String, Object> fixItems(Map<String, Object> map) {
        LinkedHashMap temp = new LinkedHashMap();
        map.forEach((key, value) -> {
            String graphQLKey = SchemaUtils.getGraphQLName(key);
            if ("item".equals(key)) {
                if (!(value instanceof List)) {
                    temp.put(graphQLKey, Collections.singletonList(this.fixItems((Map)value)));
                } else {
                    List list = (List)value;
                    temp.put(graphQLKey, list.stream().map(this::fixItems).collect(Collectors.toList()));
                }
            } else if (value instanceof Map) {
                temp.put(graphQLKey, this.fixItems((Map)value));
            } else {
                temp.put(graphQLKey, value);
            }
        });
        return MapUtils.isNotEmpty(temp) ? temp : map;
    }
}

