/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.graphql.impl.fetchers.RequestAwareDataFetcher;
import org.craftercms.engine.service.UrlTransformationService;
import org.springframework.beans.factory.annotation.Required;

public class UrlTransformDataFetcher
extends RequestAwareDataFetcher {
    protected UrlTransformationService urlTransformationService;

    @Required
    public void setUrlTransformationService(UrlTransformationService urlTransformationService) {
        this.urlTransformationService = urlTransformationService;
    }

    public Object doGet(DataFetchingEnvironment environment) {
        String transformerName;
        String fieldName = environment.getField().getName();
        Map source = (Map)environment.getSource();
        if (source.containsKey(fieldName) && Objects.nonNull(source.get(fieldName)) && StringUtils.isNotEmpty((CharSequence)(transformerName = (String)environment.getArgument("transform")))) {
            return this.urlTransformationService.transform(transformerName, source.get(fieldName).toString());
        }
        return source.get(fieldName);
    }
}

