/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.field;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.engine.graphql.GraphQLFieldFactory;
import org.craftercms.engine.graphql.SchemaUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class CheckboxGroupFieldFactory
implements GraphQLFieldFactory {
    private static final Logger logger = LoggerFactory.getLogger(CheckboxGroupFieldFactory.class);
    protected String datasourceNameXPath;
    protected String datasourceSettingsXPathFormat;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Required
    public void setDatasourceNameXPath(String datasourceNameXPath) {
        this.datasourceNameXPath = datasourceNameXPath;
    }

    @Required
    public void setDatasourceSettingsXPathFormat(String datasourceSettingsXPathFormat) {
        this.datasourceSettingsXPathFormat = datasourceSettingsXPathFormat;
    }

    @Override
    public void createField(Document contentTypeDefinition, Node contentTypeField, String contentTypeFieldId, String parentGraphQLTypeName, GraphQLObjectType.Builder parentGraphQLType, String graphQLFieldName, GraphQLFieldDefinition.Builder graphQLField) {
        String datasourceName = XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.datasourceNameXPath);
        String datasourceSettings = XmlUtils.selectSingleNodeValue((Node)contentTypeDefinition, (String)String.format(this.datasourceSettingsXPathFormat, datasourceName));
        String datasourceType = null;
        String datasourceSuffix = null;
        try {
            List typeSetting;
            Optional<Map> selectedType;
            if (StringUtils.isNotEmpty((CharSequence)datasourceSettings) && (selectedType = (typeSetting = (List)this.objectMapper.readValue(datasourceSettings, List.class)).stream().filter(s -> (Boolean)s.get("selected")).findFirst()).isPresent()) {
                datasourceType = selectedType.get().get("value").toString();
                datasourceSuffix = StringUtils.substringAfter((String)datasourceType, (String)"_");
            }
        }
        catch (IOException e) {
            logger.warn("Error checking data source type for '{}'", (Object)contentTypeFieldId);
        }
        String valueKey = "value";
        if (StringUtils.isNotEmpty(datasourceSuffix)) {
            valueKey = valueKey + "_" + datasourceSuffix + "mv";
        }
        GraphQLFieldDefinition.Builder valueField = GraphQLFieldDefinition.newFieldDefinition().name(valueKey).description("The value of the item");
        if (StringUtils.isNotEmpty(datasourceType)) {
            SchemaUtils.setTypeFromFieldName(datasourceType, valueField);
        } else {
            valueField.type((GraphQLOutputType)Scalars.GraphQLString);
            valueField.argument(SchemaUtils.TEXT_FILTER);
        }
        GraphQLObjectType itemType = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_item").description("Item for field " + contentTypeFieldId).field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("The key of the item").type((GraphQLOutputType)Scalars.GraphQLString).argument(SchemaUtils.TEXT_FILTER)).field(valueField).build();
        GraphQLObjectType itemWrapper = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_items").description("Wrapper for field " + contentTypeFieldId).field(GraphQLFieldDefinition.newFieldDefinition().name("item").description("List of items for field " + contentTypeFieldId).type((GraphQLOutputType)GraphQLList.list((GraphQLType)itemType))).build();
        graphQLField.type((GraphQLOutputType)itemWrapper);
    }
}

