/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.field;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.engine.graphql.GraphQLFieldFactory;
import org.craftercms.engine.graphql.SchemaUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class NodeSelectorFieldFactory
implements GraphQLFieldFactory {
    private static final Logger logger = LoggerFactory.getLogger(NodeSelectorFieldFactory.class);
    protected String disableFlatteningXPath;
    protected String datasourceNameXPath;
    protected String datasourceItemTypeXPathFormat;

    @Required
    public void setDisableFlatteningXPath(String disableFlatteningXPath) {
        this.disableFlatteningXPath = disableFlatteningXPath;
    }

    @Required
    public void setDatasourceNameXPath(String datasourceNameXPath) {
        this.datasourceNameXPath = datasourceNameXPath;
    }

    @Required
    public void setDatasourceItemTypeXPathFormat(String datasourceItemTypeXPathFormat) {
        this.datasourceItemTypeXPathFormat = datasourceItemTypeXPathFormat;
    }

    @Override
    public void createField(Document contentTypeDefinition, Node contentTypeField, String contentTypeFieldId, String parentGraphQLTypeName, GraphQLObjectType.Builder parentGraphQLType, String graphQLFieldName, GraphQLFieldDefinition.Builder graphQLField) {
        String itemGraphQLType;
        boolean disableFlattening = BooleanUtils.toBoolean((String)XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.disableFlatteningXPath));
        if (disableFlattening) {
            logger.debug("Flattening is disabled for node selector '{}'. Won't generate additional schema types and fields for its items", (Object)graphQLFieldName);
            graphQLField.type((GraphQLOutputType)SchemaUtils.ITEM_INCLUDE_WRAPPER_TYPE);
            return;
        }
        String datasourceName = XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.datasourceNameXPath);
        String itemType = XmlUtils.selectSingleNodeValue((Node)contentTypeDefinition, (String)String.format(this.datasourceItemTypeXPathFormat, datasourceName));
        String string = itemGraphQLType = StringUtils.isNotEmpty((CharSequence)itemType) ? SchemaUtils.getGraphQLName(itemType) : null;
        if (StringUtils.isEmpty((CharSequence)itemGraphQLType)) {
            logger.debug("No specific item type found for node selector '{}'. Won't generate additional schema types and fields for its items", (Object)graphQLFieldName);
            graphQLField.type((GraphQLOutputType)SchemaUtils.CONTENT_INCLUDE_WRAPPER_TYPE);
        } else {
            logger.debug("Item type found for node selector '{}': '{}'. Generating additional schema types and fields for the items...", (Object)itemGraphQLType, (Object)graphQLFieldName);
            GraphQLObjectType flattenedType = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_flattened_item").description("Contains the data from another item in the site").field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("The name of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("The path of the item").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("component").description("The content of the item").type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)itemGraphQLType))).build();
            GraphQLObjectType wrapperType = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_items").description("Wrapper for flattened items").field(GraphQLFieldDefinition.newFieldDefinition().name("item").description("List of flattened items").type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)flattenedType)))).build();
            graphQLField.type((GraphQLOutputType)wrapperType);
        }
    }
}

