/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.field;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.engine.graphql.GraphQLFieldFactory;
import org.craftercms.engine.graphql.GraphQLTypeFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class RepeatGroupFieldFactory
implements GraphQLFieldFactory {
    protected String fieldsXPath;
    protected GraphQLTypeFactory typeFactory;

    @Required
    public void setFieldsXPath(String fieldsXPath) {
        this.fieldsXPath = fieldsXPath;
    }

    @Required
    public void setTypeFactory(GraphQLTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public void createField(Document contentTypeDefinition, Node contentTypeField, String contentTypeFieldId, String parentGraphQLTypeName, GraphQLObjectType.Builder parentGraphQLType, String graphQLFieldName, GraphQLFieldDefinition.Builder graphQLField) {
        GraphQLObjectType.Builder repeatType = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_item").description("Item for repeat group of " + contentTypeFieldId);
        List fields = XmlUtils.selectNodes((Node)contentTypeField, (String)this.fieldsXPath, Collections.emptyMap());
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            fields.forEach(f -> this.typeFactory.createField(contentTypeDefinition, (Node)f, parentGraphQLTypeName, repeatType));
        }
        GraphQLObjectType wrapperType = GraphQLObjectType.newObject().name(parentGraphQLTypeName + "_" + graphQLFieldName + "_items").description("Wrapper for list of items of " + contentTypeFieldId).field(GraphQLFieldDefinition.newFieldDefinition().name("item").description("List of items of " + contentTypeFieldId).type((GraphQLOutputType)GraphQLList.list((GraphQLType)repeatType.build()))).build();
        graphQLField.type((GraphQLOutputType)wrapperType);
    }
}

