/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.graphql.impl.type;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.engine.graphql.GraphQLFieldFactory;
import org.craftercms.engine.graphql.GraphQLTypeFactory;
import org.craftercms.engine.graphql.SchemaUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class GraphQLTypeFactoryImpl
implements GraphQLTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLTypeFactoryImpl.class);
    public static final String CONTENT_TYPE_REGEX_PAGE = "^/?page/.*$";
    protected String rootQueryTypeName;
    protected String[] ignoredFields;
    protected String contentTypeNameXPath;
    protected String contentTypeTitleXPath;
    protected String contentTypeFieldsXPath;
    protected String contentTypeFieldIdXPath;
    protected String contentTypeFieldTypeXPath;
    protected String contentTypeFieldTitleXPath;
    protected Map<String, GraphQLFieldFactory> fieldFactories;
    protected Map<String, DataFetcher> customFetchers;

    @Required
    public void setCustomFetchers(Map<String, DataFetcher> customFetchers) {
        this.customFetchers = customFetchers;
    }

    @Required
    public void setRootQueryTypeName(String rootQueryTypeName) {
        this.rootQueryTypeName = rootQueryTypeName;
    }

    public void setIgnoredFields(String[] ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    @Required
    public void setContentTypeNameXPath(String contentTypeNameXPath) {
        this.contentTypeNameXPath = contentTypeNameXPath;
    }

    @Required
    public void setContentTypeTitleXPath(String contentTypeTitleXPath) {
        this.contentTypeTitleXPath = contentTypeTitleXPath;
    }

    @Required
    public void setContentTypeFieldsXPath(String contentTypeFieldsXPath) {
        this.contentTypeFieldsXPath = contentTypeFieldsXPath;
    }

    @Required
    public void setContentTypeFieldIdXPath(String contentTypeFieldIdXPath) {
        this.contentTypeFieldIdXPath = contentTypeFieldIdXPath;
    }

    @Required
    public void setContentTypeFieldTypeXPath(String contentTypeFieldTypeXPath) {
        this.contentTypeFieldTypeXPath = contentTypeFieldTypeXPath;
    }

    @Required
    public void setContentTypeFieldTitleXPath(String contentTypeFieldTitleXPath) {
        this.contentTypeFieldTitleXPath = contentTypeFieldTitleXPath;
    }

    @Required
    public void setFieldFactories(Map<String, GraphQLFieldFactory> fieldFactories) {
        this.fieldFactories = fieldFactories;
    }

    @Override
    public void createType(Item formDefinition, GraphQLObjectType.Builder rootGraphQLType, GraphQLCodeRegistry.Builder codeRegistry, DataFetcher<?> dataFetcher, Map<String, GraphQLObjectType.Builder> siteTypes) {
        logger.debug("Creating GraphQL Type from '{}'", (Object)formDefinition.getUrl());
        Document contentTypeDefinition = formDefinition.getDescriptorDom();
        String contentTypeName = XmlUtils.selectSingleNodeValue((Node)contentTypeDefinition, (String)this.contentTypeNameXPath);
        String graphQLTypeName = SchemaUtils.getGraphQLName(contentTypeName);
        logger.debug("Creating GraphQL Type '{}' for '{}'", (Object)graphQLTypeName, (Object)contentTypeName);
        GraphQLObjectType.Builder graphQLType = GraphQLObjectType.newObject().withInterface(SchemaUtils.CONTENT_ITEM_INTERFACE_TYPE).name(graphQLTypeName).description(XmlUtils.selectSingleNodeValue((Node)contentTypeDefinition, (String)this.contentTypeTitleXPath));
        graphQLType.fields(SchemaUtils.CONTENT_ITEM_FIELDS);
        if (contentTypeName.matches(CONTENT_TYPE_REGEX_PAGE)) {
            graphQLType.withInterface(SchemaUtils.PAGE_INTERFACE_TYPE);
            graphQLType.fields(SchemaUtils.PAGE_FIELDS);
        }
        siteTypes.put(graphQLTypeName, graphQLType);
        List contentTypeFields = XmlUtils.selectNodes((Node)contentTypeDefinition, (String)this.contentTypeFieldsXPath, Collections.emptyMap());
        if (CollectionUtils.isNotEmpty((Collection)contentTypeFields)) {
            for (Node contentTypeField : contentTypeFields) {
                this.createField(contentTypeDefinition, contentTypeField, graphQLTypeName, graphQLType);
            }
        }
        GraphQLType queryType = SchemaUtils.createQueryWrapperType(graphQLTypeName, "Query for content-type " + contentTypeName);
        rootGraphQLType.field(GraphQLFieldDefinition.newFieldDefinition().name(graphQLTypeName).description("Items of content-type " + contentTypeName).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)queryType)).arguments(SchemaUtils.TYPE_ARGUMENTS));
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)this.rootQueryTypeName, (String)graphQLTypeName), dataFetcher);
        if (MapUtils.isNotEmpty(this.customFetchers)) {
            this.customFetchers.forEach((fieldName, customFetcher) -> {
                String graphQLFieldName = SchemaUtils.getGraphQLName(fieldName);
                if (graphQLType.hasField(graphQLFieldName)) {
                    codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)graphQLTypeName, (String)graphQLFieldName), customFetcher);
                }
            });
        }
    }

    @Override
    public void createField(Document contentTypeDefinition, Node contentTypeField, String parentGraphQLTypeName, GraphQLObjectType.Builder parentGraphQLType) {
        String contentTypeFieldId = XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.contentTypeFieldIdXPath);
        if (ArrayUtils.isNotEmpty((Object[])this.ignoredFields) && ArrayUtils.contains((Object[])this.ignoredFields, (Object)contentTypeFieldId)) {
            return;
        }
        String contentTypeFieldType = XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.contentTypeFieldTypeXPath);
        String graphQLFieldName = SchemaUtils.getGraphQLName(contentTypeFieldId);
        if (!parentGraphQLType.hasField(graphQLFieldName)) {
            logger.debug("Creating GraphQL field '{}' for '{}'", (Object)graphQLFieldName, (Object)contentTypeFieldId);
            GraphQLFieldDefinition.Builder graphQLField = GraphQLFieldDefinition.newFieldDefinition().name(graphQLFieldName).description(XmlUtils.selectSingleNodeValue((Node)contentTypeField, (String)this.contentTypeFieldTitleXPath));
            if (this.fieldFactories.containsKey(contentTypeFieldType)) {
                this.fieldFactories.get(contentTypeFieldType).createField(contentTypeDefinition, contentTypeField, contentTypeFieldId, parentGraphQLTypeName, parentGraphQLType, graphQLFieldName, graphQLField);
            } else {
                SchemaUtils.setTypeFromFieldName(contentTypeFieldId, graphQLField);
            }
            parentGraphQLType.field(graphQLField);
        }
    }
}

