/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.macro.impl;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.macro.impl.AbstractMacro;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.context.ServletContextAware;

public class ScopeAttributeMacro
extends AbstractMacro
implements ServletContextAware {
    private String attributeName;
    private Scope scope = Scope.REQUEST;
    private ServletContext servletContext;

    @Required
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    protected String createMacroName() {
        return "{" + this.attributeName + "}";
    }

    @Override
    protected String getMacroValue(String str) {
        switch (this.scope) {
            case SERVLET_CONTEXT: {
                return this.getServletContextAttribute();
            }
            case SESSION: {
                return this.getSessionAttribute();
            }
        }
        return this.getRequestAttribute();
    }

    private String getServletContextAttribute() {
        return this.getAttributeAsString(this.servletContext.getAttribute(this.attributeName));
    }

    private String getSessionAttribute() {
        HttpSession session;
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null && (session = requestContext.getRequest().getSession()) != null) {
            return this.getAttributeAsString(session.getAttribute(this.attributeName));
        }
        return null;
    }

    private String getRequestAttribute() {
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null) {
            return this.getAttributeAsString(requestContext.getRequest().getAttribute(this.attributeName));
        }
        return null;
    }

    private String getAttributeAsString(Object attribute) {
        if (attribute != null) {
            return attribute.toString();
        }
        return null;
    }

    public static enum Scope {
        SERVLET_CONTEXT,
        SESSION,
        REQUEST;

    }
}

