/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.mobile;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.mobile.UserAgent;

public class UserAgentTemplateDetector {
    private List<UserAgent> supportedAgents;
    private String agentHeaderName;
    private String agentQueryStringParamName;

    public List<UserAgent> getSupportedAgents() {
        return this.supportedAgents;
    }

    public void setSupportedAgents(List<UserAgent> supportedAgents) {
        this.supportedAgents = supportedAgents;
    }

    public String getAgentHeaderName() {
        return this.agentHeaderName;
    }

    public void setAgentHeaderName(String agentHeaderName) {
        this.agentHeaderName = agentHeaderName;
    }

    public String getAgentQueryStringParamName() {
        return this.agentQueryStringParamName;
    }

    public void setAgentQueryStringParamName(String agentQueryStringParamName) {
        this.agentQueryStringParamName = agentQueryStringParamName;
    }

    public String resolveAgentTemplate(HttpServletRequest request, String template) {
        String templateFile;
        String templatePath;
        block4: {
            block3: {
                templatePath = template.substring(0, template.lastIndexOf(47) + 1);
                templateFile = template.substring(template.lastIndexOf(47) + 1);
                String queryStringParam = request.getParameter(this.agentQueryStringParamName);
                if (StringUtils.isEmpty((CharSequence)queryStringParam)) break block3;
                Iterator<UserAgent> iter = this.supportedAgents.iterator();
                boolean found = false;
                while (!found && iter.hasNext()) {
                    UserAgent userAgent = iter.next();
                    found = StringUtils.equalsIgnoreCase((CharSequence)queryStringParam, (CharSequence)userAgent.getQueryStringParamValue());
                    if (!found) continue;
                    templateFile = userAgent.getTemplatePrefix() + templateFile;
                }
                break block4;
            }
            String agent = request.getHeader(this.agentHeaderName);
            if (StringUtils.isEmpty((CharSequence)agent)) {
                agent = request.getHeader("User-Agent");
            }
            if (!StringUtils.isNotEmpty((CharSequence)agent)) break block4;
            Iterator<UserAgent> iter = this.supportedAgents.iterator();
            boolean found = false;
            while (!found && iter.hasNext()) {
                Pattern pattern;
                Matcher matcher;
                UserAgent userAgent = iter.next();
                if (!StringUtils.isNotEmpty((CharSequence)userAgent.getDetectionRegex()) || !(found = (matcher = (pattern = Pattern.compile(userAgent.getDetectionRegex())).matcher(agent)).find())) continue;
                templateFile = userAgent.getTemplatePrefix() + templateFile;
            }
        }
        return templatePath + templateFile;
    }
}

