/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.engine.model.AbstractXmlSiteItem;
import org.craftercms.engine.model.SiteItem;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultSiteItem
extends AbstractXmlSiteItem {
    protected Item item;
    protected List<SiteItem> childItems;
    protected Comparator<SiteItem> sortComparator;

    public DefaultSiteItem(Item item, Converter<Element, Object> modelFieldConverter, Comparator<SiteItem> sortComparator) {
        super(modelFieldConverter);
        this.item = item;
        this.sortComparator = sortComparator;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public String getStoreName() {
        return this.item.getName();
    }

    @Override
    public String getStoreUrl() {
        return this.item.getUrl();
    }

    @Override
    public boolean isFolder() {
        return this.item.isFolder();
    }

    @Override
    public Document getDom() {
        return this.item.getDescriptorDom();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.item.getProperties();
    }

    @Override
    protected Element getRootElement() {
        if (this.getDom() != null) {
            return this.getDom().getRootElement();
        }
        return null;
    }

    @Override
    public List<SiteItem> getChildItems() {
        if (this.childItems == null) {
            if (this.item instanceof Tree) {
                List treeChildren = ((Tree)this.item).getChildren();
                if (CollectionUtils.isNotEmpty((Collection)treeChildren)) {
                    this.childItems = new ArrayList<SiteItem>(treeChildren.size());
                    for (Item treeChild : treeChildren) {
                        this.childItems.add(this.createItemWrapper(treeChild));
                    }
                    if (this.sortComparator != null) {
                        this.childItems = this.sortItems(this.childItems, this.sortComparator);
                    }
                } else {
                    this.childItems = Collections.emptyList();
                }
            } else {
                this.childItems = Collections.emptyList();
            }
        }
        return this.childItems;
    }

    @Override
    public SiteItem getChildItem(String storeName) {
        for (SiteItem childItem : this.getChildItems()) {
            if (!childItem.getStoreName().equals(storeName)) continue;
            return childItem;
        }
        return null;
    }

    public String toString() {
        return "SiteItem[storeName='" + this.getStoreName() + '\'' + ", storeUrl='" + this.getStoreUrl() + '\'' + ", folder=" + this.isFolder() + ']';
    }

    @Override
    public List<SiteItem> sortItems(List<SiteItem> items, Comparator<SiteItem> comparator) {
        Collections.sort(items, comparator);
        return items;
    }

    @Override
    public SiteItem createItemWrapper(Item item) {
        return new DefaultSiteItem(item, (Converter<Element, Object>)this.modelFieldConverter, this.sortComparator);
    }
}

