/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.navigation.NavItem;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.service.UrlTransformationService;
import org.springframework.beans.factory.annotation.Required;

public class DefaultItemConverter
implements Converter<SiteItem, NavItem> {
    protected String navLabelXPath;
    protected String internalNameXPath;
    protected String storeUrlToRenderUrlTransformerName;
    protected UrlTransformationService urlTransformationService;

    @Required
    public void setNavLabelXPath(String navLabelXPath) {
        this.navLabelXPath = navLabelXPath;
    }

    @Required
    public void setInternalNameXPath(String internalNameXPath) {
        this.internalNameXPath = internalNameXPath;
    }

    @Required
    public void setStoreUrlToRenderUrlTransformerName(String storeUrlToRenderUrlTransformerName) {
        this.storeUrlToRenderUrlTransformerName = storeUrlToRenderUrlTransformerName;
    }

    @Required
    public void setUrlTransformationService(UrlTransformationService urlTransformationService) {
        this.urlTransformationService = urlTransformationService;
    }

    public Class<?> getSourceClass() {
        return SiteItem.class;
    }

    public Class<?> getTargetClass() {
        return NavItem.class;
    }

    public NavItem convert(SiteItem siteItem) {
        NavItem navItem = null;
        if (siteItem.getDom() != null) {
            navItem = new NavItem();
            navItem.setLabel(this.getNavigationLabel(siteItem));
            navItem.setUrl(this.getNavigationUrl(siteItem));
            navItem.setAttributes(this.getAdditionalAttributes(siteItem));
        }
        return navItem;
    }

    protected String getNavigationLabel(SiteItem siteItem) {
        String navLabel = siteItem.queryValue(this.navLabelXPath);
        if (StringUtils.isEmpty((CharSequence)navLabel) && StringUtils.isEmpty((CharSequence)(navLabel = siteItem.queryValue(this.internalNameXPath)))) {
            navLabel = FilenameUtils.removeExtension((String)siteItem.getStoreName());
            navLabel = StringUtils.replace((String)navLabel, (String)"-", (String)" ");
            navLabel = StringUtils.capitalize((String)navLabel);
        }
        return navLabel;
    }

    protected String getNavigationUrl(SiteItem siteItem) {
        return this.urlTransformationService.transform(this.storeUrlToRenderUrlTransformerName, siteItem.getStoreUrl());
    }

    protected Map<String, String> getAdditionalAttributes(SiteItem siteItem) {
        String[] fields;
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (String field : fields = SiteProperties.getNavigationAdditionalFields()) {
            String value = siteItem.queryValue(field);
            if (value == null) continue;
            attrs.put(field, value);
        }
        return attrs;
    }

    public String toString() {
        return "DefaultItemConverter{navLabelXPath='" + this.navLabelXPath + '\'' + ", internalNameXPath='" + this.internalNameXPath + '\'' + ", storeUrlToRenderUrlTransformerName='" + this.storeUrlToRenderUrlTransformerName + '\'' + ", urlTransformationService=" + this.urlTransformationService + '}';
    }
}

