/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.engine.targeting.TargetIdManager;
import org.springframework.beans.factory.annotation.Required;

public class FolderToIndexItemProcessor
implements ItemProcessor {
    protected String folderToIndexUrlTransformerName;
    protected UrlTransformationEngine urlTransformationEngine;
    protected ContentStoreService storeService;
    protected TargetIdManager targetIdManager;

    @Required
    public void setFolderToIndexUrlTransformerName(String folderToIndexUrlTransformerName) {
        this.folderToIndexUrlTransformerName = folderToIndexUrlTransformerName;
    }

    @Required
    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setTargetIdManager(TargetIdManager targetIdManager) {
        this.targetIdManager = targetIdManager;
    }

    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String folderUrl;
        String indexUrl;
        Item indexItem;
        if (item.isFolder() && (indexItem = this.storeService.findItem(context, cachingOptions, indexUrl = this.urlTransformationEngine.transformUrl(context, cachingOptions, this.folderToIndexUrlTransformerName, folderUrl = item.getUrl()), null)) != null) {
            Item newFolderItem = new Item(item);
            newFolderItem.setDescriptorUrl(indexItem.getDescriptorUrl());
            newFolderItem.setDescriptorDom(indexItem.getDescriptorDom());
            return newFolderItem;
        }
        return item;
    }

    public String toString() {
        return "FolderToIndexItemProcessor{currentTargetId='" + this.targetIdManager.getCurrentTargetId() + '\'' + ", folderToIndexUrlTransformerName='" + this.folderToIndexUrlTransformerName + '\'' + ", urlTransformationEngine=" + this.urlTransformationEngine + ", storeService=" + this.storeService + '}';
    }
}

