/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.navigation.NavBreadcrumbBuilder;
import org.craftercms.engine.navigation.NavItem;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.service.SiteItemService;
import org.springframework.beans.factory.annotation.Required;

public class NavBreadcrumbBuilderImpl
implements NavBreadcrumbBuilder {
    public static final String BREADCRUMB_CONST_KEY_ELEM = "breadcrumb";
    protected SiteItemService siteItemService;
    protected ItemProcessor processor;
    protected Converter<SiteItem, NavItem> defaultItemConverter;

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    public void setProcessor(ItemProcessor processor) {
        this.processor = processor;
    }

    public void setProcessors(List<ItemProcessor> processors) {
        this.processor = new ItemProcessorPipeline(processors);
    }

    public void setDefaultItemConverter(Converter<SiteItem, NavItem> defaultItemConverter) {
        this.defaultItemConverter = defaultItemConverter;
    }

    @Override
    public List<NavItem> getBreadcrumb(String url, String root) {
        return this.getBreadcrumb(url, root, null);
    }

    @Override
    public List<NavItem> getBreadcrumb(String url, String root, Converter<SiteItem, NavItem> itemConverter) {
        if (itemConverter == null) {
            itemConverter = this.defaultItemConverter;
        }
        ArrayList<NavItem> breadcrumb = new ArrayList<NavItem>();
        String breadcrumbUrl = this.extractBreadcrumbUrl(url, root);
        String[] breadcrumbUrlComponents = breadcrumbUrl.split("/");
        String currentUrl = root;
        for (String breadcrumbUrlComponent : breadcrumbUrlComponents) {
            NavItem navItem;
            SiteItem siteItem = this.siteItemService.getSiteItem(currentUrl = UrlUtils.concat((String)currentUrl, (String)breadcrumbUrlComponent), this.processor);
            if (siteItem == null || (navItem = (NavItem)itemConverter.convert((Object)siteItem)) == null) continue;
            navItem.setActive(url.equals(siteItem.getItem().getDescriptorUrl()));
            breadcrumb.add(navItem);
        }
        return breadcrumb;
    }

    protected String extractBreadcrumbUrl(String url, String root) {
        String indexFileName = SiteProperties.getIndexFileName();
        String breadcrumbUrl = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)url, (String)root), (String)indexFileName);
        if (!breadcrumbUrl.startsWith("/")) {
            breadcrumbUrl = "/" + breadcrumbUrl;
        }
        return breadcrumbUrl;
    }
}

