/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.impl.CompositeItemFilter;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.navigation.NavItem;
import org.craftercms.engine.navigation.NavTreeBuilder;
import org.craftercms.engine.service.SiteItemService;
import org.springframework.beans.factory.annotation.Required;

public class NavTreeBuilderImpl
implements NavTreeBuilder {
    protected SiteItemService siteItemService;
    protected ItemFilter filter;
    protected ItemProcessor processor;
    protected Converter<SiteItem, NavItem> defaultItemConverter;

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    public void setFilter(ItemFilter filter) {
        this.filter = filter;
    }

    public void setProcessor(ItemProcessor processor) {
        this.processor = processor;
    }

    public void setFilters(List<ItemFilter> filters) {
        this.filter = new CompositeItemFilter(filters);
    }

    public void setProcessors(List<ItemProcessor> processors) {
        this.processor = new ItemProcessorPipeline(processors);
    }

    @Required
    public void setDefaultItemConverter(Converter<SiteItem, NavItem> defaultItemConverter) {
        this.defaultItemConverter = defaultItemConverter;
    }

    @Override
    public NavItem getNavTree(String url, int depth, String currentPageUrl) {
        return this.getNavTree(url, depth, currentPageUrl, null);
    }

    @Override
    public NavItem getNavTree(String url, int depth, String currentPageUrl, Converter<SiteItem, NavItem> itemConverter) {
        if (itemConverter == null) {
            itemConverter = this.defaultItemConverter;
        }
        SiteItem treeRoot = this.siteItemService.getSiteTree(url, depth, this.filter, this.processor);
        return this.getNavItem(treeRoot, currentPageUrl, itemConverter);
    }

    protected NavItem getNavItem(SiteItem siteItem, String currentPageUrl, Converter<SiteItem, NavItem> itemConverter) {
        NavItem navItem = (NavItem)itemConverter.convert((Object)siteItem);
        if (navItem != null) {
            navItem.setSubItems(this.getNavSubItems(siteItem, currentPageUrl, itemConverter));
            navItem.setActive(this.isActive(currentPageUrl, siteItem.getStoreUrl()));
            return navItem;
        }
        return null;
    }

    protected List<NavItem> getNavSubItems(SiteItem siteItem, String currentPageUrl, Converter<SiteItem, NavItem> itemConverter) {
        List<SiteItem> childItems = siteItem.getChildItems();
        if (CollectionUtils.isNotEmpty(childItems)) {
            ArrayList<NavItem> navSubItems = new ArrayList<NavItem>();
            for (SiteItem childItem : childItems) {
                NavItem navSubItem = this.getNavItem(childItem, currentPageUrl, itemConverter);
                if (navSubItem == null || navSubItems.contains(navSubItem)) continue;
                navSubItems.add(navSubItem);
            }
            return navSubItems;
        }
        return Collections.emptyList();
    }

    protected boolean isActive(String currentPageUrl, String pageUrl) {
        if (!currentPageUrl.startsWith("/")) {
            currentPageUrl = "/" + currentPageUrl;
        }
        if (!currentPageUrl.endsWith("/")) {
            currentPageUrl = currentPageUrl + "/";
        }
        if (!pageUrl.startsWith("/")) {
            pageUrl = "/" + pageUrl;
        }
        if (!pageUrl.endsWith("/")) {
            pageUrl = pageUrl + "/";
        }
        return currentPageUrl.startsWith(pageUrl);
    }
}

