/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.TargetedUrlComponents;
import org.craftercms.engine.targeting.TargetedUrlStrategy;
import org.springframework.beans.factory.annotation.Required;

public class RejectIndexFilesItemFilter
implements ItemFilter {
    protected TargetedUrlStrategy targetedUrlStrategy;

    @Required
    public void setTargetedUrlStrategy(TargetedUrlStrategy targetedUrlStrategy) {
        this.targetedUrlStrategy = targetedUrlStrategy;
    }

    public boolean runBeforeProcessing() {
        return true;
    }

    public boolean runAfterProcessing() {
        return false;
    }

    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        TargetedUrlComponents targetedFileNameComponents;
        String itemFileName;
        String indexFileName = SiteProperties.getIndexFileName();
        if (indexFileName.equals(itemFileName = item.getName())) {
            return false;
        }
        if (SiteProperties.isTargetingEnabled() && this.targetedUrlStrategy.isFileNameBasedStrategy() && (targetedFileNameComponents = this.targetedUrlStrategy.parseTargetedUrl(itemFileName)) != null) {
            String prefix = targetedFileNameComponents.getPrefix();
            String suffix = targetedFileNameComponents.getSuffix();
            String nonTargetedItemFileName = this.targetedUrlStrategy.buildTargetedUrl(prefix, null, suffix);
            if (indexFileName.equals(nonTargetedItemFileName = StringUtils.strip((String)nonTargetedItemFileName, (String)"/"))) {
                return false;
            }
        }
        return true;
    }
}

