/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.navigation.impl;

import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.TargetIdManager;
import org.springframework.beans.factory.annotation.Required;

public class ToCurrentTargetedVersionItemProcessor
implements ItemProcessor {
    protected String toCurrentTargetedUrlTransformerName;
    protected UrlTransformationEngine urlTransformationEngine;
    protected ContentStoreService storeService;
    protected TargetIdManager targetIdManager;

    @Required
    public void setToCurrentTargetedUrlTransformerName(String toCurrentTargetedUrlTransformerName) {
        this.toCurrentTargetedUrlTransformerName = toCurrentTargetedUrlTransformerName;
    }

    @Required
    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setTargetIdManager(TargetIdManager targetIdManager) {
        this.targetIdManager = targetIdManager;
    }

    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String url;
        String targetedUrl;
        Item targetedItem;
        if (!item.isFolder() && SiteProperties.isTargetingEnabled() && (targetedItem = this.storeService.findItem(context, cachingOptions, targetedUrl = this.urlTransformationEngine.transformUrl(context, cachingOptions, this.toCurrentTargetedUrlTransformerName, url = item.getUrl()), null)) != null) {
            return targetedItem;
        }
        return item;
    }

    public String toString() {
        return "ToCurrentTargetedVersionItemProcessor{currentTargetId='" + this.targetIdManager.getCurrentTargetId() + '\'' + ", toCurrentTargetedUrlTransformerName='" + this.toCurrentTargetedUrlTransformerName + '\'' + ", urlTransformationEngine=" + this.urlTransformationEngine + ", storeService=" + this.storeService + '}';
    }
}

