/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.properties;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.engine.util.CacheUtils;
import org.craftercms.engine.util.ConfigUtils;

public class SiteProperties {
    public static final String INDEX_FILE_NAME_CONFIG_KEY = "indexFileName";
    public static final String DISABLE_FULL_MODEL_TYPE_CONVERSION_CONFIG_KEY = "compatibility.disableFullModelTypeConversion";
    public static final String NAVIGATION_ADDITIONAL_FIELDS_CONFIG_KEY = "navigation.additionalFields";
    public static final String SPA_ENABLED_CONFIG_KEY = "spa.enabled";
    public static final String SPA_VIEW_NAME = "spa.viewName";
    public static final String TARGETING_ENABLED_CONFIG_KEY = "targeting.enabled";
    public static final String AVAILABLE_TARGET_IDS_CONFIG_KEY = "targeting.availableTargetIds";
    public static final String FALLBACK_ID_CONFIG_KEY = "targeting.fallbackTargetId";
    public static final String ROOT_FOLDERS_CONFIG_KEY = "targeting.rootFolders";
    public static final String EXCLUDE_PATTERNS_CONFIG_KEY = "targeting.excludePatterns";
    public static final String MERGE_FOLDERS_CONFIG_KEY = "targeting.mergeFolders";
    public static final String REDIRECT_TO_TARGETED_URL_CONFIG_KEY = "targeting.redirectToTargetedUrl";
    public static final String CACHE_WARMUP_DESCRIPTOR_FOLDERS_CONFIG_KEY = "cache.warmUp.descriptorFolders";
    public static final String CACHE_WARMUP_CONTENT_FOLDERS_CONFIG_KEY = "cache.warmUp.contentFolders";
    public static final String DEFAULT_INDEX_FILE_NAME = "index.xml";
    public static final String DEFAULT_SPA_VIEW_NAME = "/";

    public static boolean isTargetingEnabled() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(TARGETING_ENABLED_CONFIG_KEY, false);
        }
        return false;
    }

    public static String[] getAvailableTargetIds() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getStringArray(AVAILABLE_TARGET_IDS_CONFIG_KEY);
        }
        return null;
    }

    public static String getFallbackTargetId() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getString(FALLBACK_ID_CONFIG_KEY);
        }
        return null;
    }

    public static String[] getRootFolders() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getStringArray(ROOT_FOLDERS_CONFIG_KEY);
        }
        return null;
    }

    public static String[] getExcludePatterns() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getStringArray(EXCLUDE_PATTERNS_CONFIG_KEY);
        }
        return null;
    }

    public static boolean isMergeFolders() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(MERGE_FOLDERS_CONFIG_KEY, false);
        }
        return false;
    }

    public static boolean isRedirectToTargetedUrl() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(REDIRECT_TO_TARGETED_URL_CONFIG_KEY, false);
        }
        return false;
    }

    public static final String getIndexFileName() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getString(INDEX_FILE_NAME_CONFIG_KEY, DEFAULT_INDEX_FILE_NAME);
        }
        return DEFAULT_INDEX_FILE_NAME;
    }

    public static boolean isDisableFullModelTypeConversion() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(DISABLE_FULL_MODEL_TYPE_CONVERSION_CONFIG_KEY, false);
        }
        return false;
    }

    public static String[] getNavigationAdditionalFields() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null && config.containsKey(NAVIGATION_ADDITIONAL_FIELDS_CONFIG_KEY)) {
            return config.getStringArray(NAVIGATION_ADDITIONAL_FIELDS_CONFIG_KEY);
        }
        return new String[0];
    }

    public static boolean isSpaEnabled() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(SPA_ENABLED_CONFIG_KEY, false);
        }
        return false;
    }

    public static String getSpaViewName() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getString(SPA_VIEW_NAME, DEFAULT_SPA_VIEW_NAME);
        }
        return DEFAULT_SPA_VIEW_NAME;
    }

    public static final Map<String, Integer> getDescriptorPreloadFolders() {
        Object[] folders;
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null && ArrayUtils.isNotEmpty((Object[])(folders = config.getStringArray(CACHE_WARMUP_DESCRIPTOR_FOLDERS_CONFIG_KEY)))) {
            return CacheUtils.parsePreloadFoldersList((String[])folders);
        }
        return Collections.emptyMap();
    }

    public static final Map<String, Integer> getContentPreloadFolders() {
        Object[] folders;
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null && ArrayUtils.isNotEmpty((Object[])(folders = config.getStringArray(CACHE_WARMUP_CONTENT_FOLDERS_CONFIG_KEY)))) {
            return CacheUtils.parsePreloadFoldersList((String[])folders);
        }
        return Collections.emptyMap();
    }
}

