/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.engine.exception.SchedulingException;
import org.craftercms.engine.scripting.ScriptJobResolver;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ContentStoreUtils;
import org.craftercms.engine.util.SchedulingUtils;
import org.craftercms.engine.util.quartz.JobContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.context.ServletContextAware;

public class ConfigurationScriptJobResolver
implements ScriptJobResolver,
ServletContextAware {
    public static final String JOB_FOLDER_KEY = "jobs.jobFolder";
    public static final String JOB_KEY = "jobs.job";
    public static final String PATH_KEY = "path";
    public static final String CRON_EXPRESSION_KEY = "cronExpression";
    protected String scriptSuffix;
    protected ServletContext servletContext;
    protected boolean disableVariableRestrictions;

    @Required
    public void setScriptSuffix(String scriptSuffix) {
        this.scriptSuffix = scriptSuffix;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDisableVariableRestrictions(boolean disableVariableRestrictions) {
        this.disableVariableRestrictions = disableVariableRestrictions;
    }

    @Override
    public List<JobContext> resolveJobs(SiteContext siteContext) throws SchedulingException {
        HierarchicalConfiguration config = siteContext.getConfig();
        ArrayList<JobContext> jobContexts = new ArrayList<JobContext>();
        if (config != null) {
            List jobsConfig;
            List jobFoldersConfig = config.configurationsAt(JOB_FOLDER_KEY);
            if (CollectionUtils.isNotEmpty((Collection)jobFoldersConfig)) {
                for (HierarchicalConfiguration jobFolderConfig : jobFoldersConfig) {
                    List<JobContext> folderJobContexts = this.getJobsUnderFolder(siteContext, jobFolderConfig);
                    if (!CollectionUtils.isNotEmpty(folderJobContexts)) continue;
                    jobContexts.addAll(folderJobContexts);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(jobsConfig = config.configurationsAt(JOB_KEY)))) {
                for (HierarchicalConfiguration jobConfig : jobsConfig) {
                    JobContext jobContext = this.getJob(siteContext, jobConfig);
                    if (jobContext == null) continue;
                    jobContexts.add(jobContext);
                }
            }
        }
        return jobContexts;
    }

    protected List<JobContext> getJobsUnderFolder(SiteContext siteContext, HierarchicalConfiguration jobFolderConfig) {
        List<String> scriptPaths;
        ArrayList<JobContext> jobContexts = null;
        String folderPath = jobFolderConfig.getString(PATH_KEY);
        String cronExpression = jobFolderConfig.getString(CRON_EXPRESSION_KEY);
        ContentStoreService storeService = siteContext.getStoreService();
        Context context = siteContext.getContext();
        if (StringUtils.isNotEmpty((CharSequence)folderPath) && StringUtils.isNotEmpty((CharSequence)cronExpression) && CollectionUtils.isNotEmpty(scriptPaths = ContentStoreUtils.findChildrenUrl(storeService, context, folderPath))) {
            for (String scriptPath : scriptPaths) {
                if (!scriptPath.endsWith(this.scriptSuffix)) continue;
                if (jobContexts == null) {
                    jobContexts = new ArrayList<JobContext>();
                }
                jobContexts.add(SchedulingUtils.createJobContext(siteContext, scriptPath, cronExpression, this.disableVariableRestrictions ? this.servletContext : null));
            }
        }
        return jobContexts;
    }

    protected JobContext getJob(SiteContext siteContext, HierarchicalConfiguration jobConfig) {
        String scriptPath = jobConfig.getString(PATH_KEY);
        String cronExpression = jobConfig.getString(CRON_EXPRESSION_KEY);
        if (StringUtils.isNotEmpty((CharSequence)scriptPath) && StringUtils.isNotEmpty((CharSequence)cronExpression)) {
            if (siteContext.getStoreService().exists(siteContext.getContext(), scriptPath)) {
                return SchedulingUtils.createJobContext(siteContext, scriptPath, cronExpression, this.disableVariableRestrictions ? this.servletContext : null);
            }
            throw new SchedulingException("Script job " + scriptPath + " for site '" + siteContext.getSiteName() + "' not found");
        }
        return null;
    }
}

