/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import groovy.lang.Binding;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.craftercms.core.util.cache.impl.AbstractCachingAwareObject;
import org.craftercms.engine.exception.ScriptException;
import org.craftercms.engine.scripting.Script;
import org.slf4j.MDC;

public class GroovyScript
extends AbstractCachingAwareObject
implements Script {
    private static final String SCRIPT_URL_MDC_KEY = "scriptUrl";
    protected String scriptUrl;
    protected Class<?> scriptClass;
    protected Map<String, Object> globalVariables;

    public GroovyScript(String scriptUrl, Class<?> scriptClass, Map<String, Object> globalVariables) {
        this.scriptUrl = scriptUrl;
        this.scriptClass = scriptClass;
        this.globalVariables = globalVariables;
    }

    @Override
    public String getUrl() {
        return this.scriptUrl;
    }

    @Override
    public Object execute(Map<String, Object> variables) throws ScriptException {
        HashMap<String, Object> allVariables = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty(this.globalVariables)) {
            allVariables.putAll(this.globalVariables);
        }
        if (MapUtils.isNotEmpty(variables)) {
            allVariables.putAll(variables);
        }
        MDC.put((String)SCRIPT_URL_MDC_KEY, (String)this.scriptUrl);
        try {
            Object object = InvokerHelper.createScript(this.scriptClass, (Binding)new Binding(allVariables)).run();
            return object;
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage(), e);
        }
        finally {
            MDC.remove((String)SCRIPT_URL_MDC_KEY);
        }
    }

    public String toString() {
        return "GroovyScript{scriptUrl='" + this.scriptUrl + '\'' + '}';
    }
}

