/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.io.FileNotFoundException;
import java.util.Map;
import org.craftercms.engine.exception.ScriptException;
import org.craftercms.engine.exception.ScriptNotFoundException;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.impl.GroovyScript;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;

public class GroovyScriptFactory
implements ScriptFactory {
    public static final String CACHE_CONST_KEY_ELEM_SCRIPT = "groovyScript";
    public static final String GROOVY_FILE_EXTENSION = "groovy";
    protected SiteContext siteContext;
    protected GroovyScriptEngine scriptEngine;
    protected Map<String, Object> globalVariables;

    public GroovyScriptFactory(SiteContext siteContext, ResourceConnector resourceConnector, Map<String, Object> globalVariables, boolean enableScriptSandbox) {
        this.siteContext = siteContext;
        this.scriptEngine = new GroovyScriptEngine(resourceConnector);
        this.scriptEngine.setConfig(GroovyScriptUtils.getCompilerConfiguration(enableScriptSandbox));
        this.globalVariables = globalVariables;
    }

    public GroovyScriptFactory(SiteContext siteContext, ResourceConnector resourceConnector, ClassLoader parentClassLoader, Map<String, Object> globalVariables, boolean enableScriptSandbox) {
        this.siteContext = siteContext;
        this.scriptEngine = new GroovyScriptEngine(resourceConnector, parentClassLoader);
        this.scriptEngine.setConfig(GroovyScriptUtils.getCompilerConfiguration(enableScriptSandbox));
        this.globalVariables = globalVariables;
    }

    @Override
    public String getScriptFileExtension() {
        return GROOVY_FILE_EXTENSION;
    }

    @Override
    public Script getScript(String url) throws ScriptException {
        return (Script)this.siteContext.getCacheTemplate().getObject(this.siteContext.getContext(), () -> {
            try {
                return new GroovyScript(url, this.scriptEngine.loadScriptByName(url), this.globalVariables);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (e instanceof ResourceException && cause instanceof FileNotFoundException) {
                    throw new ScriptNotFoundException(cause.getMessage(), cause);
                }
                throw new ScriptException(e.getMessage(), e);
            }
        }, new Object[]{url, CACHE_CONST_KEY_ELEM_SCRIPT});
    }
}

