/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.exception.ConfigurationException;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.impl.ScriptFilterChainImpl;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ScriptFilter
implements Filter {
    public static final String FILTER_KEY = "filters.filter";
    public static final String SCRIPT_KEY = "script";
    public static final String INCLUDE_MAPPINGS_KEY = "mapping.include";
    public static final String EXCLUDE_MAPPINGS_KEY = "mapping.exclude";
    public static final String FILTER_MAPPINGS_CACHE_KEY = "filterMappings";
    private ServletContext servletContext;
    private CacheTemplate cacheTemplate;
    protected PathMatcher pathMatcher = new AntPathMatcher();
    protected boolean disableVariableRestrictions;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public void setDisableVariableRestrictions(boolean disableVariableRestrictions) {
        this.disableVariableRestrictions = disableVariableRestrictions;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        List<FilterMapping> filterMappings = this.getFilterMappings();
        if (CollectionUtils.isNotEmpty(filterMappings)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String requestUri = HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)httpRequest);
            ArrayList<Script> scripts = new ArrayList<Script>();
            for (FilterMapping mapping : filterMappings) {
                if (this.excludeRequest(requestUri, mapping.excludes) || !this.includeRequest(requestUri, mapping.includes)) continue;
                scripts.add(mapping.script);
            }
            if (CollectionUtils.isNotEmpty(scripts)) {
                chain = new ScriptFilterChainImpl(scripts.iterator(), chain, this.disableVariableRestrictions ? this.servletContext : null);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected List<FilterMapping> getFilterMappings() {
        final SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            Callback<List<FilterMapping>> callback = new Callback<List<FilterMapping>>(){

                public List<FilterMapping> execute() {
                    List filtersConfig;
                    HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
                    CachingAwareList mappings = new CachingAwareList();
                    if (config != null && CollectionUtils.isNotEmpty((Collection)(filtersConfig = config.configurationsAt(ScriptFilter.FILTER_KEY)))) {
                        for (HierarchicalConfiguration filterConfig : filtersConfig) {
                            String scriptUrl = filterConfig.getString(ScriptFilter.SCRIPT_KEY);
                            Object[] includes = filterConfig.getStringArray(ScriptFilter.INCLUDE_MAPPINGS_KEY);
                            String[] excludes = filterConfig.getStringArray(ScriptFilter.EXCLUDE_MAPPINGS_KEY);
                            if (!StringUtils.isNotEmpty((CharSequence)scriptUrl) || !ArrayUtils.isNotEmpty((Object[])includes)) continue;
                            ContentStoreService storeService = siteContext.getStoreService();
                            ScriptFactory scriptFactory = siteContext.getScriptFactory();
                            if (!storeService.exists(siteContext.getContext(), scriptUrl)) {
                                throw new ConfigurationException("No filter script found at " + scriptUrl);
                            }
                            FilterMapping mapping = new FilterMapping();
                            mapping.script = scriptFactory.getScript(scriptUrl);
                            FilterMapping.access$102(mapping, (String[])includes);
                            FilterMapping.access$002(mapping, excludes);
                            mappings.add((Object)mapping);
                        }
                    }
                    return mappings;
                }
            };
            return (List)this.cacheTemplate.getObject(siteContext.getContext(), (Callback)callback, new Object[]{FILTER_MAPPINGS_CACHE_KEY});
        }
        return null;
    }

    protected boolean excludeRequest(String requestUri, String[] excludes) {
        if (ArrayUtils.isNotEmpty((Object[])excludes)) {
            for (String uriPattern : excludes) {
                if (!this.pathMatcher.match(uriPattern, requestUri)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean includeRequest(String requestUri, String[] includes) {
        if (ArrayUtils.isNotEmpty((Object[])includes)) {
            for (String uriPattern : includes) {
                if (!this.pathMatcher.match(uriPattern, requestUri)) continue;
                return true;
            }
        }
        return false;
    }

    protected static class FilterMapping {
        private Script script;
        private String[] includes;
        private String[] excludes;

        protected FilterMapping() {
        }

        static /* synthetic */ String[] access$102(FilterMapping x0, String[] x1) {
            x0.includes = x1;
            return x1;
        }

        static /* synthetic */ String[] access$002(FilterMapping x0, String[] x1) {
            x0.excludes = x1;
            return x1;
        }
    }
}

