/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.exception.ScriptException;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.util.GroovyScriptUtils;

public class ScriptFilterChainImpl
implements FilterChain {
    private static final Log logger = LogFactory.getLog(ScriptFilterChainImpl.class);
    private Iterator<Script> scriptIterator;
    private FilterChain delegateChain;
    private ServletContext servletContext;

    public ScriptFilterChainImpl(Iterator<Script> scriptIterator, FilterChain delegateChain, ServletContext servletContext) {
        this.scriptIterator = scriptIterator;
        this.delegateChain = delegateChain;
        this.servletContext = servletContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.scriptIterator.hasNext()) {
            Script script = this.scriptIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing filter script at " + script.getUrl()));
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            GroovyScriptUtils.addFilterScriptVariables(variables, httpRequest, httpResponse, this.servletContext, this);
            try {
                script.execute(variables);
            }
            catch (ScriptException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ServletException) {
                    throw (ServletException)cause;
                }
                throw new ServletException("Error executing filter script at " + script.getUrl(), cause);
            }
        } else {
            this.delegateChain.doFilter(request, response);
        }
    }
}

