/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptUrlTemplateScanner;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.util.UriTemplate;

public class ScriptUrlTemplateScannerImpl
implements ScriptUrlTemplateScanner {
    public static final String DEFAULT_URL_VARIABLE_PLACEHOLDER_PATTERN = "\\{[^{}]+\\}";
    protected Pattern urlVariablePlaceholderPattern = Pattern.compile("\\{[^{}]+\\}");
    protected String scriptsFolder;

    public void setUrlVariablePlaceholderPattern(String urlVariablePlaceholderPattern) {
        this.urlVariablePlaceholderPattern = Pattern.compile(urlVariablePlaceholderPattern);
    }

    @Required
    public void setScriptsFolder(String scriptsFolder) {
        this.scriptsFolder = scriptsFolder;
    }

    @Override
    public List<UriTemplate> scan(SiteContext siteContext) {
        Context context = siteContext.getContext();
        ContentStoreService storeService = siteContext.getStoreService();
        ScriptFactory scriptFactory = siteContext.getScriptFactory();
        ArrayList<String> scriptUrls = new ArrayList<String>();
        ArrayList<UriTemplate> urlTemplates = new ArrayList<UriTemplate>();
        this.findScripts(context, storeService, scriptFactory, this.scriptsFolder, scriptUrls);
        if (CollectionUtils.isNotEmpty(scriptUrls)) {
            for (String scriptUrl : scriptUrls) {
                Matcher matcher = this.urlVariablePlaceholderPattern.matcher(scriptUrl);
                if (!matcher.find()) continue;
                urlTemplates.add(new UriTemplate(scriptUrl));
            }
        }
        return urlTemplates;
    }

    public void findScripts(Context context, ContentStoreService storeService, ScriptFactory scriptFactory, String folder, List<String> scriptUrls) {
        List items = storeService.findChildren(context, null, folder, null, null);
        String scriptFileExtension = scriptFactory.getScriptFileExtension();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (Item item : items) {
                if (!item.isFolder() && item.getName().endsWith(scriptFileExtension)) {
                    scriptUrls.add(item.getUrl());
                    continue;
                }
                if (!item.isFolder()) continue;
                this.findScripts(context, storeService, scriptFactory, item.getUrl(), scriptUrls);
            }
        }
    }
}

