/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.SiteItemScriptResolver;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;

public class SiteItemScriptResolverImpl
implements SiteItemScriptResolver {
    private static final Log logger = LogFactory.getLog(SiteItemScriptResolverImpl.class);
    protected ContentStoreService storeService;
    protected String contentTypeXPathQuery;
    protected Pattern contentTypePattern;
    protected String scriptUrlFormat;
    protected String scriptsXPathQuery;

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setContentTypeXPathQuery(String contentTypeXPathQuery) {
        this.contentTypeXPathQuery = contentTypeXPathQuery;
    }

    @Required
    public void setContentTypePattern(String contentTypePattern) {
        this.contentTypePattern = Pattern.compile(contentTypePattern);
    }

    @Required
    public void setScriptUrlFormat(String scriptUrlFormat) {
        this.scriptUrlFormat = scriptUrlFormat;
    }

    @Required
    public void setScriptsXPathQuery(String scriptsXPathQuery) {
        this.scriptsXPathQuery = scriptsXPathQuery;
    }

    @Override
    public List<String> getScriptUrls(SiteItem item) {
        List<String> scriptUrls = null;
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            String scriptUrl;
            String contentType = item.queryValue(this.contentTypeXPathQuery);
            if (StringUtils.isNotEmpty((CharSequence)contentType) && StringUtils.isNotEmpty((CharSequence)(scriptUrl = this.getScriptUrlForContentType(contentType)))) {
                try {
                    if (this.storeService.exists(siteContext.getContext(), scriptUrl)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Script for content type '" + contentType + "' found at " + scriptUrl));
                        }
                        scriptUrls = new ArrayList<String>();
                        scriptUrls.add(scriptUrl);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No script for content type '" + contentType + "' found at " + scriptUrl));
                    }
                }
                catch (CrafterException e) {
                    logger.error((Object)("Error retrieving script for content type '" + contentType + "' at " + scriptUrl), (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty(scriptUrls)) {
                List<String> additionalUrls = item.queryValues(this.scriptsXPathQuery);
                if (scriptUrls == null) {
                    scriptUrls = new ArrayList<String>();
                }
                if (CollectionUtils.isNotEmpty(additionalUrls)) {
                    scriptUrls.addAll(additionalUrls);
                }
            } else {
                scriptUrls = item.queryValues(this.scriptsXPathQuery);
            }
        }
        return scriptUrls;
    }

    protected String getScriptUrlForContentType(String contentType) {
        Matcher contentTypeMatcher = this.contentTypePattern.matcher(contentType);
        if (contentTypeMatcher.matches()) {
            String contentTypeName = contentTypeMatcher.group(1);
            contentTypeName = StringUtils.strip((String)contentTypeName, (String)"/");
            return String.format(this.scriptUrlFormat, contentTypeName);
        }
        return null;
    }
}

