/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.search;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.search.elasticsearch.impl.AbstractElasticsearchWrapper;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SiteAwareElasticsearchService
extends AbstractElasticsearchWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SiteAwareElasticsearchService.class);
    private static final String DEFAULT_ROLE_FIELD_NAME = "authorizedRoles.item.role";
    private static final String ROLE_PREFIX = "ROLE_";
    protected String indexIdFormat;
    protected String roleFieldName = "authorizedRoles.item.role";

    public SiteAwareElasticsearchService(RestHighLevelClient client, String indexIdFormat) {
        super(client);
        this.indexIdFormat = indexIdFormat;
    }

    public void setRoleFieldName(String roleFieldName) {
        this.roleFieldName = roleFieldName;
    }

    protected void updateIndex(SearchRequest request) {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext == null) {
            throw new IllegalStateException("Current site context not found");
        }
        request.indices(new String[]{String.format(this.indexIdFormat, siteContext.getSiteName())});
    }

    protected void updateFilters(SearchRequest request) {
        super.updateFilters(request);
        BoolQueryBuilder mainQuery = (BoolQueryBuilder)request.source().query();
        Authentication auth = null;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null) {
            auth = context.getAuthentication();
        }
        BoolQueryBuilder securityQuery = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.roleFieldName))).should((QueryBuilder)QueryBuilders.matchQuery((String)this.roleFieldName, (Object)"anonymous"));
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken) && CollectionUtils.isNotEmpty((Collection)auth.getAuthorities())) {
            logger.debug("Filtering search results for roles: {}", (Object)auth.getAuthorities());
            securityQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)this.roleFieldName, (Object)auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(role -> role + " " + (StringUtils.startsWith((CharSequence)role, (CharSequence)ROLE_PREFIX) ? StringUtils.removeStart((String)role, (String)ROLE_PREFIX) : StringUtils.appendIfMissing((String)role, (CharSequence)ROLE_PREFIX, (CharSequence[])new CharSequence[0]))).collect(Collectors.joining(" "))));
        } else {
            logger.debug("Filtering search to show only public items");
        }
        mainQuery.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)securityQuery));
    }
}

