/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.search;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.Content;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.search.exception.SearchException;
import org.craftercms.search.service.Query;
import org.craftercms.search.service.SearchService;
import org.springframework.beans.factory.annotation.Required;

public class SiteAwareSearchService
implements SearchService<Query> {
    protected String indexIdFormat;
    protected SearchService<Query> actualSearchService;

    @Required
    public void setIndexIdFormat(String indexIdFormat) {
        this.indexIdFormat = indexIdFormat;
    }

    @Required
    public void setActualSearchService(SearchService<Query> actualSearchService) {
        this.actualSearchService = actualSearchService;
    }

    public Query createQuery() {
        return this.actualSearchService.createQuery();
    }

    public Query createQuery(Map<String, String[]> params) {
        return this.actualSearchService.createQuery(params);
    }

    public Map<String, Object> search(Query query) throws SearchException {
        return this.actualSearchService.search(this.getActualIndexId(null), query);
    }

    public Map<String, Object> search(String indexId, Query query) throws SearchException {
        return this.actualSearchService.search(this.getActualIndexId(indexId), query);
    }

    public void update(String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        this.actualSearchService.update(this.getActualIndexId(null), site, id, xml, ignoreRootInFieldNames);
    }

    public void update(String indexId, String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        this.actualSearchService.update(this.getActualIndexId(indexId), site, id, xml, ignoreRootInFieldNames);
    }

    public void delete(String site, String id) throws SearchException {
        this.actualSearchService.delete(this.getActualIndexId(null), site, id);
    }

    public void delete(String indexId, String site, String id) throws SearchException {
        this.actualSearchService.delete(this.getActualIndexId(indexId), site, id);
    }

    public void updateContent(String site, String id, File file) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(null), site, id, file);
    }

    public void updateContent(String indexId, String site, String id, File file) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(indexId), site, id, file);
    }

    public void updateContent(String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(null), site, id, file, additionalFields);
    }

    public void updateContent(String indexId, String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(indexId), site, id, file, additionalFields);
    }

    public void updateContent(String site, String id, Content content) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(null), site, id, content);
    }

    public void updateContent(String indexId, String site, String id, Content content) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(indexId), site, id, content);
    }

    public void updateContent(String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(null), site, id, content, additionalFields);
    }

    public void updateContent(String indexId, String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        this.actualSearchService.updateContent(this.getActualIndexId(indexId), site, id, content, additionalFields);
    }

    public void commit() throws SearchException {
        this.actualSearchService.commit(this.getActualIndexId(null));
    }

    public void commit(String indexId) throws SearchException {
        this.actualSearchService.commit(this.getActualIndexId(indexId));
    }

    protected String getActualIndexId(String indexId) {
        if (StringUtils.isEmpty((CharSequence)indexId)) {
            return String.format(this.indexIdFormat, this.getCurrentSiteName());
        }
        return String.format(this.indexIdFormat, indexId);
    }

    protected String getCurrentSiteName() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getSiteName();
        }
        throw new IllegalStateException("Current site context not found");
    }
}

