/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.security;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.security.annotations.RunIfSecurityEnabled;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class CrafterPageAccessManager {
    private static final String ROLE_PREFIX = "ROLE_";
    protected String authorizedRolesXPathQuery;

    @Required
    public void setAuthorizedRolesXPathQuery(String authorizedRolesXPathQuery) {
        this.authorizedRolesXPathQuery = authorizedRolesXPathQuery;
    }

    @RunIfSecurityEnabled
    public void checkAccess(SiteItem page) {
        List<String> authorizedRoles;
        String pageUrl = page.getStoreUrl();
        Authentication auth = null;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && context.getAuthentication() != null) {
            auth = context.getAuthentication();
        }
        if (CollectionUtils.isNotEmpty(authorizedRoles = this.getAuthorizedRolesForPage(page)) && !this.containsRole("anonymous", authorizedRoles)) {
            if (auth == null || auth instanceof AnonymousAuthenticationToken) {
                throw new AccessDeniedException("User is anonymous but page '" + pageUrl + "' requires authentication");
            }
            if (!this.containsRole("authenticated", authorizedRoles) && !this.hasAnyRole(auth, authorizedRoles)) {
                throw new AccessDeniedException("User '" + auth.getName() + "' is not authorized to view page '" + pageUrl + "'");
            }
        }
    }

    protected List<String> getAuthorizedRolesForPage(SiteItem page) {
        return page.queryValues(this.authorizedRolesXPathQuery);
    }

    protected boolean containsRole(String role, List<String> roles) {
        for (String r : roles) {
            if (!StringUtils.removeStart((String)r, (String)ROLE_PREFIX).equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnyRole(Authentication auth, List<String> roles) {
        return auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(authority -> StringUtils.removeStart((String)authority, (String)ROLE_PREFIX)).anyMatch(authority -> this.containsRole((String)authority, roles));
    }
}

