/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.service.context.SiteResolver;
import org.springframework.beans.factory.annotation.Required;

public class CookieSiteResolver
implements SiteResolver {
    private static final Log logger = LogFactory.getLog(CookieSiteResolver.class);
    protected String paramOrCookieName;

    @Required
    public void setParamOrCookieName(String paramOrCookieName) {
        this.paramOrCookieName = paramOrCookieName;
    }

    @Override
    public String getSiteName(HttpServletRequest request) {
        String siteName = request.getParameter(this.paramOrCookieName);
        if (StringUtils.isEmpty((CharSequence)siteName) && StringUtils.isEmpty((CharSequence)(siteName = HttpUtils.getCookieValue((String)this.paramOrCookieName, (HttpServletRequest)request))) && logger.isDebugEnabled()) {
            logger.debug((Object)("No '" + this.paramOrCookieName + "' request param or cookie found"));
        }
        return siteName;
    }
}

