/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.macro.MacroResolver;
import org.craftercms.engine.service.context.SiteListResolver;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class FolderScanningSiteListResolver
implements SiteListResolver,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(FolderScanningSiteListResolver.class);
    public static final String SITE_ROOT_FOLDER_PATH_REGEX = "^(([^:]+:)?(.+?/))([^/]*\\{%s\\}[^/]*)(/.*)?$";
    public static final int SITES_FOLDER_PATH_GROUP = 1;
    public static final int SITE_FOLDER_NAME_FORMAT_GROUP = 4;
    protected String siteRootFolderPath;
    protected String siteNameMacroName = "siteName";
    protected MacroResolver macroResolver;
    protected ResourceLoader resourceLoader;
    protected String sitesFolderPath;
    protected Pattern siteFolderNamePattern;

    @Required
    public void setSiteRootFolderPath(String siteRootFolderPath) {
        this.siteRootFolderPath = siteRootFolderPath;
    }

    public void setSiteNameMacroName(String siteNameMacroName) {
        this.siteNameMacroName = siteNameMacroName;
    }

    @Required
    public void setMacroResolver(MacroResolver macroResolver) {
        this.macroResolver = macroResolver;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @PostConstruct
    public void init() {
        String siteRootFolderPathRegex = String.format(SITE_ROOT_FOLDER_PATH_REGEX, this.siteNameMacroName);
        Pattern siteRootFolderPathPattern = Pattern.compile(siteRootFolderPathRegex);
        Matcher siteRootFolderPathMatcher = siteRootFolderPathPattern.matcher(this.siteRootFolderPath);
        if (!siteRootFolderPathMatcher.matches()) {
            throw new IllegalStateException("The site root folder path " + this.siteRootFolderPath + " doesn't match the regex " + siteRootFolderPathRegex);
        }
        this.sitesFolderPath = siteRootFolderPathMatcher.group(1);
        this.sitesFolderPath = this.macroResolver.resolveMacros(this.sitesFolderPath);
        String siteFolderNameFormat = siteRootFolderPathMatcher.group(4);
        String siteFolderNameRegex = siteFolderNameFormat.replace("{" + this.siteNameMacroName + "}", "(.+)");
        this.siteFolderNamePattern = Pattern.compile(siteFolderNameRegex);
    }

    @Override
    public Collection<String> getSiteList() {
        Object[] files;
        ArrayList<String> siteNames = new ArrayList<String>();
        File sitesFolder = this.getSitesFolder();
        if (sitesFolder != null && ArrayUtils.isNotEmpty((Object[])(files = sitesFolder.listFiles()))) {
            for (Object file : files) {
                Matcher siteFolderNameMatcher;
                if (!((File)file).isDirectory() || !(siteFolderNameMatcher = this.siteFolderNamePattern.matcher(((File)file).getName())).matches()) continue;
                siteNames.add(siteFolderNameMatcher.group(1));
            }
        }
        return siteNames;
    }

    protected File getSitesFolder() {
        try {
            File sitesFolder = this.resourceLoader.getResource(this.sitesFolderPath).getFile();
            if (sitesFolder.exists()) {
                logger.info((Object)("Sites folder resolved to " + sitesFolder.getAbsolutePath()));
                return sitesFolder;
            }
            logger.error((Object)("Sites folder " + this.sitesFolderPath + " doesn't exist"));
            return null;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to retrieve sites folder " + this.sitesFolderPath), (Throwable)e);
            return null;
        }
    }
}

