/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.SiteResolver;
import org.springframework.beans.factory.annotation.Required;

public class RequestUriSiteResolver
implements SiteResolver {
    private static final Log logger = LogFactory.getLog(RequestUriSiteResolver.class);
    protected String siteNameRegex;
    protected int siteNameRegexGroup;

    @Required
    public void setSiteNameRegex(String siteNameRegex) {
        this.siteNameRegex = siteNameRegex;
    }

    @Required
    public void setSiteNameRegexGroup(int siteNameRegexGroup) {
        this.siteNameRegexGroup = siteNameRegexGroup;
    }

    @Override
    public String getSiteName(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        Matcher matcher = Pattern.compile(this.siteNameRegex).matcher(requestUri);
        String siteName = null;
        if (matcher.matches()) {
            siteName = matcher.group(this.siteNameRegexGroup);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to match request URI " + requestUri + " to regex " + this.siteNameRegex));
        }
        return siteName;
    }
}

