/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import graphql.GraphQL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.time.StopWatch;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.cache.SiteCacheWarmer;
import org.craftercms.engine.event.CacheClearCompletedEvent;
import org.craftercms.engine.event.CacheClearStartedEvent;
import org.craftercms.engine.event.GraphQLBuildCompletedEvent;
import org.craftercms.engine.event.GraphQLBuildStartedEvent;
import org.craftercms.engine.event.SiteContextCreatedEvent;
import org.craftercms.engine.event.SiteContextDestroyedEvent;
import org.craftercms.engine.event.SiteContextInitializedEvent;
import org.craftercms.engine.event.SiteEvent;
import org.craftercms.engine.exception.GraphQLBuildException;
import org.craftercms.engine.exception.SiteContextInitializationException;
import org.craftercms.engine.graphql.GraphQLFactory;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

public class SiteContext {
    private static final Logger logger = LoggerFactory.getLogger(SiteContext.class);
    private static final String SITE_NAME_MDC_KEY = "siteName";
    private static ThreadLocal<SiteContext> threadLocal = new ThreadLocal();
    protected ContentStoreService storeService;
    protected CacheTemplate cacheTemplate;
    protected String siteName;
    protected Context context;
    protected boolean fallback;
    protected String staticAssetsPath;
    protected String templatesPath;
    protected String[] allowedTemplatePaths;
    protected String restScriptsPath;
    protected String controllerScriptsPath;
    protected String initScriptPath;
    protected FreeMarkerConfig freeMarkerConfig;
    protected UrlTransformationEngine urlTransformationEngine;
    protected ScriptFactory scriptFactory;
    protected HierarchicalConfiguration config;
    protected ServletContext servletContext;
    protected ApplicationContext globalApplicationContext;
    protected ConfigurableApplicationContext applicationContext;
    protected URLClassLoader classLoader;
    protected UrlRewriter urlRewriter;
    protected Scheduler scheduler;
    protected GraphQLFactory graphQLFactory;
    protected SiteCacheWarmer cacheWarmer;
    protected HierarchicalConfiguration proxyConfig;
    protected long initTimeout;
    protected CountDownLatch initializationLatch;
    protected ExecutorService maintenanceTaskExecutor;
    protected GraphQL graphQL;
    protected State state;
    private long shutdownTimeout;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock accessLock = this.readWriteLock.readLock();
    private final Lock shutdownLock = this.readWriteLock.writeLock();
    protected SandboxInterceptor scriptSandbox;

    public static SiteContext getCurrent() {
        return threadLocal.get();
    }

    public static <T> T getFromCurrentCache(Callback<T> loader, Object ... keyElements) {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getFromCache(loader, keyElements);
        }
        return (T)loader.execute();
    }

    public static void setCurrent(SiteContext siteContext) {
        SiteContext current = threadLocal.get();
        if (current != null) {
            logger.debug("Overwriting previous site context {}", (Object)current);
            SiteContext.release(current);
        }
        logger.debug("Getting access lock for context {}", (Object)siteContext);
        siteContext.accessLock.lock();
        try {
            if (siteContext.scriptSandbox != null) {
                siteContext.scriptSandbox.register();
            }
            threadLocal.set(siteContext);
            MDC.put((String)SITE_NAME_MDC_KEY, (String)siteContext.getSiteName());
        }
        catch (Error | RuntimeException e) {
            siteContext.accessLock.unlock();
            throw e;
        }
    }

    public static void clear() {
        MDC.remove((String)SITE_NAME_MDC_KEY);
        SiteContext current = threadLocal.get();
        if (current == null) {
            logger.debug("Current site context was already cleared");
            return;
        }
        SiteContext.release(current);
        threadLocal.remove();
    }

    protected static void release(SiteContext siteContext) {
        if (siteContext.scriptSandbox != null) {
            siteContext.scriptSandbox.unregister();
        }
        logger.debug("Releasing access lock for context {}", (Object)siteContext);
        siteContext.accessLock.unlock();
    }

    public SiteContext() {
        this.maintenanceTaskExecutor = Executors.newSingleThreadExecutor();
        this.state = State.INITIALIZING;
        this.initializationLatch = new CountDownLatch(1);
    }

    public ContentStoreService getStoreService() {
        return this.storeService;
    }

    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    public CacheTemplate getCacheTemplate() {
        return this.cacheTemplate;
    }

    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public String getStaticAssetsPath() {
        return this.staticAssetsPath;
    }

    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public String[] getAllowedTemplatePaths() {
        return this.allowedTemplatePaths;
    }

    public void setAllowedTemplatePaths(String[] allowedTemplatePaths) {
        this.allowedTemplatePaths = allowedTemplatePaths;
    }

    public String getRestScriptsPath() {
        return this.restScriptsPath;
    }

    public void setRestScriptsPath(String restScriptsPath) {
        this.restScriptsPath = restScriptsPath;
    }

    public String getControllerScriptsPath() {
        return this.controllerScriptsPath;
    }

    public void setControllerScriptsPath(String controllerScriptsPath) {
        this.controllerScriptsPath = controllerScriptsPath;
    }

    public String getInitScriptPath() {
        return this.initScriptPath;
    }

    public void setInitScriptPath(String initScriptPath) {
        this.initScriptPath = initScriptPath;
    }

    public FreeMarkerConfig getFreeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void setFreeMarkerConfig(FreeMarkerConfig freeMarkerConfig) {
        this.freeMarkerConfig = freeMarkerConfig;
    }

    public UrlTransformationEngine getUrlTransformationEngine() {
        return this.urlTransformationEngine;
    }

    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    public ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    public HierarchicalConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(HierarchicalConfiguration config) {
        this.config = config;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ApplicationContext getGlobalApplicationContext() {
        return this.globalApplicationContext;
    }

    public void setGlobalApplicationContext(ApplicationContext globalApplicationContext) {
        this.globalApplicationContext = globalApplicationContext;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public UrlRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public GraphQLFactory getGraphQLFactory() {
        return this.graphQLFactory;
    }

    public void setGraphQLFactory(GraphQLFactory graphQLFactory) {
        this.graphQLFactory = graphQLFactory;
    }

    public SiteCacheWarmer getCacheWarmer() {
        return this.cacheWarmer;
    }

    public void setCacheWarmer(SiteCacheWarmer cacheWarmer) {
        this.cacheWarmer = cacheWarmer;
    }

    public void setInitTimeout(long initTimeout) {
        this.initTimeout = initTimeout;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public GraphQL getGraphQL() {
        return this.graphQL;
    }

    public HierarchicalConfiguration getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(HierarchicalConfiguration proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public boolean isValid() throws CrafterException {
        try {
            if (this.state == State.INITIALIZING) {
                logger.debug("Waiting for initialization of {}", (Object)this);
                this.initializationLatch.await(this.initTimeout, TimeUnit.MILLISECONDS);
            }
            return this.state == State.READY && this.storeService.validate(this.context);
        }
        catch (InterruptedException e) {
            throw new CrafterException("Error while waiting for initialization of " + this);
        }
    }

    public State getState() {
        return this.state;
    }

    public void init(boolean waitTillFinished) throws SiteContextInitializationException {
        if (this.state == State.INITIALIZING) {
            this.publishEvent(new SiteContextCreatedEvent(this));
            Runnable initTask = () -> {
                SiteContext.setCurrent(this);
                try {
                    logger.info("--------------------------------------------------");
                    logger.info("<Initializing context site: " + this.siteName + ">");
                    logger.info("--------------------------------------------------");
                    if (this.cacheWarmer != null) {
                        this.cacheWarmer.warmUpCache(this, false);
                    }
                    this.buildGraphQLSchema();
                    this.executeInitScript();
                    this.state = State.READY;
                    logger.info("--------------------------------------------------");
                    logger.info("</Initializing context site: " + this.siteName + ">");
                    logger.info("--------------------------------------------------");
                    this.publishEvent(new SiteContextInitializedEvent(this));
                }
                catch (Exception e) {
                    this.destroy();
                    throw e;
                }
                finally {
                    this.initializationLatch.countDown();
                    SiteContext.clear();
                }
            };
            if (waitTillFinished) {
                Future<?> future = this.maintenanceTaskExecutor.submit(initTask);
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new SiteContextInitializationException("Error while waiting for context init", e);
                }
            } else {
                this.maintenanceTaskExecutor.execute(initTask);
            }
        }
    }

    public void startCacheClear() {
        this.maintenanceTaskExecutor.execute(() -> {
            SiteContext.setCurrent(this);
            try {
                this.cacheClear();
            }
            finally {
                SiteContext.clear();
            }
        });
    }

    public void startGraphQLSchemaBuild() throws GraphQLBuildException {
        this.maintenanceTaskExecutor.execute(() -> {
            SiteContext.setCurrent(this);
            try {
                this.buildGraphQLSchema();
            }
            finally {
                SiteContext.clear();
            }
        });
    }

    public void destroy() throws CrafterException {
        block18: {
            try {
                logger.debug("Getting shutdown lock for context {}", (Object)this);
                boolean locked = this.shutdownLock.tryLock(this.shutdownTimeout, TimeUnit.MINUTES);
                try {
                    if (!locked) {
                        logger.debug("Time out reached, proceeding to destroy context {}", (Object)this);
                    } else {
                        logger.debug("All threads released, proceeding to destroy context {}", (Object)this);
                    }
                    this.state = State.DESTROYED;
                    this.publishEvent(new SiteContextDestroyedEvent(this));
                    this.maintenanceTaskExecutor.shutdownNow();
                    this.storeService.destroyContext(this.context);
                    if (this.scheduler != null) {
                        try {
                            this.scheduler.shutdown();
                        }
                        catch (SchedulerException e) {
                            throw new CrafterException("Unable to shutdown scheduler", (Throwable)e);
                        }
                    }
                    if (this.applicationContext != null) {
                        try {
                            this.applicationContext.close();
                        }
                        catch (Exception e) {
                            throw new CrafterException("Unable to close application context", (Throwable)e);
                        }
                    }
                    if (this.classLoader == null) break block18;
                    try {
                        this.classLoader.close();
                    }
                    catch (Exception e) {
                        throw new CrafterException("Unable to close class loader", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Error destroying context {}", (Object)this, (Object)e);
                }
                finally {
                    if (locked) {
                        logger.debug("Releasing shutdown lock for context {}", (Object)this);
                        this.shutdownLock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new CrafterException("Unable to destroy context", (Throwable)e);
            }
        }
    }

    public <T> T getFromCache(Callback<T> loader, Object ... keyElements) {
        return (T)this.cacheTemplate.getObject(this.context, loader, keyElements);
    }

    protected void cacheClear() {
        this.publishEvent(new CacheClearStartedEvent(this));
        if (this.cacheWarmer != null) {
            this.cacheWarmer.warmUpCache(this, true);
            this.freeMarkerConfig.getConfiguration().clearTemplateCache();
        } else {
            this.cacheTemplate.getCacheService().clearScope(this.context);
            this.freeMarkerConfig.getConfiguration().clearTemplateCache();
        }
        this.publishEvent(new CacheClearCompletedEvent(this));
    }

    protected void buildGraphQLSchema() {
        logger.info("Starting GraphQL schema build for site '{}'", (Object)this.siteName);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.publishEvent(new GraphQLBuildStartedEvent(this));
        try {
            GraphQL graphQL = this.graphQLFactory.getInstance(this);
            if (Objects.nonNull(graphQL)) {
                this.graphQL = graphQL;
                this.publishEvent(new GraphQLBuildCompletedEvent(this));
            }
        }
        catch (Exception e) {
            logger.error("Error building the GraphQL schema for site '" + this.siteName + "'", (Throwable)e);
        }
        stopWatch.stop();
        logger.info("GraphQL schema build completed for site '{}' in {} secs", (Object)this.siteName, (Object)stopWatch.getTime(TimeUnit.SECONDS));
    }

    protected void executeInitScript() {
        if (this.storeService.exists(this.context, this.initScriptPath)) {
            try {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                GroovyScriptUtils.addJobScriptVariables(variables, this.servletContext);
                logger.info("Executing init script for site '{}'", (Object)this.siteName);
                this.scriptFactory.getScript(this.initScriptPath).execute(variables);
            }
            catch (Exception e) {
                logger.error("Error executing init script for site '" + this.siteName + "'", (Throwable)e);
            }
        }
    }

    protected void publishEvent(SiteEvent event) {
        if (this.applicationContext != null) {
            this.applicationContext.publishEvent((ApplicationEvent)event);
        } else {
            this.globalApplicationContext.publishEvent((ApplicationEvent)event);
        }
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null) {
            requestContext.getRequest().setAttribute(((Object)((Object)event)).getClass().getName(), (Object)event);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteContext siteContext = (SiteContext)o;
        return this.siteName.equals(siteContext.siteName);
    }

    public int hashCode() {
        return this.siteName.hashCode();
    }

    public String toString() {
        return "SiteContext{siteName='" + this.siteName + '\'' + ", context=" + this.context + ", fallback=" + this.fallback + ", staticAssetsPath='" + this.staticAssetsPath + '\'' + ", templatesPath='" + this.templatesPath + '\'' + ", restScriptsPath='" + this.restScriptsPath + '\'' + ", controllerScriptsPath='" + this.controllerScriptsPath + '\'' + '}';
    }

    public static enum State {
        INITIALIZING,
        READY,
        DESTROYED;

    }
}

