/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.EncryptionAwareConfigurationReader;
import org.craftercms.commons.config.PublishingTargetResolver;
import org.craftercms.commons.spring.ApacheCommonsConfiguration2PropertySource;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.cache.SiteCacheWarmer;
import org.craftercms.engine.exception.SiteContextCreationException;
import org.craftercms.engine.graphql.GraphQLFactory;
import org.craftercms.engine.macro.MacroResolver;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptJobResolver;
import org.craftercms.engine.scripting.impl.GroovyScriptFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.craftercms.engine.util.SchedulingUtils;
import org.craftercms.engine.util.config.SiteAwarePublishingTargetResolver;
import org.craftercms.engine.util.groovy.ContentStoreGroovyResourceLoader;
import org.craftercms.engine.util.groovy.ContentStoreResourceConnector;
import org.craftercms.engine.util.groovy.Dom4jExtension;
import org.craftercms.engine.util.quartz.JobContext;
import org.craftercms.engine.util.spring.ContentStoreResourceLoader;
import org.craftercms.engine.util.spring.context.RestrictedApplicationContext;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.blacklists.Blacklist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.PermitAllWhitelist;
import org.quartz.Scheduler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

public class SiteContextFactory
implements ApplicationContextAware,
ServletContextAware {
    public static final String DEFAULT_SITE_NAME_MACRO_NAME = "siteName";
    public static final long DEFAULT_INIT_TIMEOUT = 300000L;
    public static final String CONFIG_BEAN_NAME = "siteConfig";
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5L;
    public static final String DEFAULT_PUBLISHING_TARGET_MACRO_NAME = "publishingTarget";
    public static final String CONFIG_KEY_ALLOWED_TEMPLATE_PATHS = "templates.allowed";
    private static final Log logger = LogFactory.getLog(SiteContextFactory.class);
    protected ServletContext servletContext;
    protected String siteNameMacroName = "siteName";
    protected String storeType;
    protected String rootFolderPath;
    protected String staticAssetsPath;
    protected String templatesPath;
    protected String initScriptPath;
    protected String restScriptsPath;
    protected String controllerScriptsPath;
    protected String[] configPaths;
    protected String[] applicationContextPaths;
    protected String[] urlRewriteConfPaths;
    protected String[] proxyConfigPaths;
    protected String groovyClassesPath;
    protected Map<String, Object> groovyGlobalVars;
    protected boolean mergingOn = true;
    protected boolean cacheOn = true;
    protected int maxAllowedItemsInCache = 0;
    protected boolean ignoreHiddenFiles = true;
    protected ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory;
    protected UrlTransformationEngine urlTransformationEngine;
    protected ContentStoreService storeService;
    protected CacheTemplate cacheTemplate;
    protected MacroResolver macroResolver;
    protected ApplicationContext globalApplicationContext;
    protected List<ScriptJobResolver> jobResolvers;
    protected Executor jobThreadPoolExecutor;
    protected GraphQLFactory graphQLFactory;
    protected boolean cacheWarmUpEnabled;
    protected SiteCacheWarmer cacheWarmer;
    protected long initTimeout = 300000L;
    protected boolean disableVariableRestrictions;
    protected EncryptionAwareConfigurationReader configurationReader;
    protected String[] defaultPublicBeans = new String[0];
    protected long shutdownTimeout = 5L;
    protected PublishingTargetResolver publishingTargetResolver;
    protected String publishingTargetMacroName = "publishingTarget";
    protected boolean enableScriptSandbox;
    protected boolean enableSandboxBlacklist;
    protected String sandboxBlacklist;
    protected boolean enableExpressions;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSiteNameMacroName(String siteNameMacroName) {
        this.siteNameMacroName = siteNameMacroName;
    }

    @Required
    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    @Required
    public void setRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
    }

    @Required
    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    @Required
    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    @Required
    public void setInitScriptPath(String initScriptPath) {
        this.initScriptPath = initScriptPath;
    }

    @Required
    public void setRestScriptsPath(String restScriptsPath) {
        this.restScriptsPath = restScriptsPath;
    }

    @Required
    public void setControllerScriptsPath(String controllerScriptsPath) {
        this.controllerScriptsPath = controllerScriptsPath;
    }

    @Required
    public void setConfigPaths(String[] configPaths) {
        this.configPaths = configPaths;
    }

    @Required
    public void setApplicationContextPaths(String[] applicationContextPaths) {
        this.applicationContextPaths = applicationContextPaths;
    }

    @Required
    public void setUrlRewriteConfPaths(String[] urlRewriteConfPaths) {
        this.urlRewriteConfPaths = urlRewriteConfPaths;
    }

    @Required
    public void setProxyConfigPaths(String[] proxyConfigPaths) {
        this.proxyConfigPaths = proxyConfigPaths;
    }

    @Required
    public void setGroovyClassesPath(String groovyClassesPath) {
        this.groovyClassesPath = groovyClassesPath;
    }

    @Required
    public void setGroovyGlobalVars(Map<String, Object> groovyGlobalVars) {
        this.groovyGlobalVars = groovyGlobalVars;
    }

    public void setMergingOn(boolean mergingOn) {
        this.mergingOn = mergingOn;
    }

    public void setCacheOn(boolean cacheOn) {
        this.cacheOn = cacheOn;
    }

    public void setMaxAllowedItemsInCache(int maxAllowedItemsInCache) {
        this.maxAllowedItemsInCache = maxAllowedItemsInCache;
    }

    public void setIgnoreHiddenFiles(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    @Required
    public void setFreeMarkerConfigFactory(ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory) {
        this.freeMarkerConfigFactory = freeMarkerConfigFactory;
    }

    @Required
    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Required
    public void setMacroResolver(MacroResolver macroResolver) {
        this.macroResolver = macroResolver;
    }

    @Required
    public void setJobResolvers(List<ScriptJobResolver> jobResolvers) {
        this.jobResolvers = jobResolvers;
    }

    @Required
    public void setJobThreadPoolExecutor(Executor jobThreadPoolExecutor) {
        this.jobThreadPoolExecutor = jobThreadPoolExecutor;
    }

    @Required
    public void setGraphQLFactory(GraphQLFactory graphQLFactory) {
        this.graphQLFactory = graphQLFactory;
    }

    @Required
    public void setCacheWarmUpEnabled(boolean cacheWarmUpEnabled) {
        this.cacheWarmUpEnabled = cacheWarmUpEnabled;
    }

    @Required
    public void setCacheWarmer(SiteCacheWarmer cacheWarmer) {
        this.cacheWarmer = cacheWarmer;
    }

    public void setInitTimeout(long initTimeout) {
        this.initTimeout = initTimeout;
    }

    public void setDisableVariableRestrictions(boolean disableVariableRestrictions) {
        this.disableVariableRestrictions = disableVariableRestrictions;
    }

    @Required
    public void setConfigurationReader(EncryptionAwareConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public void setDefaultPublicBeans(String[] defaultPublicBeans) {
        this.defaultPublicBeans = defaultPublicBeans;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setPublishingTargetResolver(PublishingTargetResolver publishingTargetResolver) {
        this.publishingTargetResolver = publishingTargetResolver;
    }

    public void setEnableScriptSandbox(boolean enableScriptSandbox) {
        this.enableScriptSandbox = enableScriptSandbox;
    }

    public void setEnableSandboxBlacklist(boolean enableSandboxBlacklist) {
        this.enableSandboxBlacklist = enableSandboxBlacklist;
    }

    public void setSandboxBlacklist(String sandboxBlacklist) {
        this.sandboxBlacklist = sandboxBlacklist;
    }

    public void setEnableExpressions(boolean enableExpressions) {
        this.enableExpressions = enableExpressions;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.globalApplicationContext = applicationContext;
    }

    public SiteContext createContext(String siteName) {
        HashMap<String, String> macroValues = new HashMap<String, String>();
        macroValues.put(this.siteNameMacroName, siteName);
        if (this.publishingTargetResolver instanceof SiteAwarePublishingTargetResolver) {
            String target = ((SiteAwarePublishingTargetResolver)this.publishingTargetResolver).getPublishingTarget(siteName);
            macroValues.put(this.publishingTargetMacroName, target);
        }
        String resolvedRootFolderPath = this.macroResolver.resolveMacros(this.rootFolderPath, macroValues);
        Context context = this.storeService.getContext(UUID.randomUUID().toString(), this.storeType, resolvedRootFolderPath, this.mergingOn, this.cacheOn, this.maxAllowedItemsInCache, this.ignoreHiddenFiles);
        try {
            SiteContext siteContext = new SiteContext();
            siteContext.setInitTimeout(this.initTimeout);
            siteContext.setStoreService(this.storeService);
            siteContext.setCacheTemplate(this.cacheTemplate);
            siteContext.setSiteName(siteName);
            siteContext.setContext(context);
            siteContext.setStaticAssetsPath(this.staticAssetsPath);
            siteContext.setTemplatesPath(this.templatesPath);
            siteContext.setInitScriptPath(this.initScriptPath);
            siteContext.setFreeMarkerConfig((FreeMarkerConfig)this.freeMarkerConfigFactory.getObject());
            siteContext.setUrlTransformationEngine(this.urlTransformationEngine);
            siteContext.setRestScriptsPath(this.restScriptsPath);
            siteContext.setControllerScriptsPath(this.controllerScriptsPath);
            siteContext.setGraphQLFactory(this.graphQLFactory);
            siteContext.setShutdownTimeout(this.shutdownTimeout);
            if (this.disableVariableRestrictions) {
                siteContext.setServletContext(this.servletContext);
            }
            if (this.cacheWarmUpEnabled) {
                siteContext.setCacheWarmer(this.cacheWarmer);
            }
            String[] resolvedConfigPaths = new String[this.configPaths.length];
            for (int i = 0; i < this.configPaths.length; ++i) {
                resolvedConfigPaths[i] = this.macroResolver.resolveMacros(this.configPaths[i], macroValues);
            }
            String[] resolvedAppContextPaths = new String[this.applicationContextPaths.length];
            for (int i = 0; i < this.applicationContextPaths.length; ++i) {
                resolvedAppContextPaths[i] = this.macroResolver.resolveMacros(this.applicationContextPaths[i], macroValues);
            }
            String[] resolvedUrlRewriteConfPaths = new String[this.urlRewriteConfPaths.length];
            for (int i = 0; i < this.urlRewriteConfPaths.length; ++i) {
                resolvedUrlRewriteConfPaths[i] = this.macroResolver.resolveMacros(this.urlRewriteConfPaths[i], macroValues);
            }
            List<String> resolvedProxyConfPaths = Stream.of(this.proxyConfigPaths).map(path -> this.macroResolver.resolveMacros((String)path, (Map<String, ?>)macroValues)).collect(Collectors.toList());
            ContentStoreResourceLoader resourceLoader = new ContentStoreResourceLoader(siteContext);
            HierarchicalConfiguration config = this.getConfig(siteContext, resolvedConfigPaths, (ResourceLoader)resourceLoader);
            this.configureScriptSandbox(siteContext, (ResourceLoader)resourceLoader);
            URLClassLoader classLoader = this.getClassLoader(siteContext);
            ScriptFactory scriptFactory = this.getScriptFactory(siteContext, classLoader);
            ConfigurableApplicationContext appContext = this.getApplicationContext(siteContext, classLoader, config, resolvedAppContextPaths, (ResourceLoader)resourceLoader);
            UrlRewriter urlRewriter = this.getUrlRewriter(siteContext, resolvedUrlRewriteConfPaths, (ResourceLoader)resourceLoader);
            HierarchicalConfiguration proxyConfig = this.getProxyConfig(siteContext, resolvedProxyConfPaths, (ResourceLoader)resourceLoader);
            siteContext.setScriptFactory(scriptFactory);
            siteContext.setConfig(config);
            siteContext.setGlobalApplicationContext(this.globalApplicationContext);
            siteContext.setApplicationContext(appContext);
            siteContext.setClassLoader(classLoader);
            siteContext.setUrlRewriter(urlRewriter);
            siteContext.setProxyConfig(proxyConfig);
            if (config != null) {
                siteContext.setAllowedTemplatePaths(config.getStringArray(CONFIG_KEY_ALLOWED_TEMPLATE_PATHS));
            }
            Scheduler scheduler = this.scheduleJobs(siteContext);
            siteContext.setScheduler(scheduler);
            return siteContext;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating context for site '" + siteName + "'"), (Throwable)e);
            this.storeService.destroyContext(context);
            throw e;
        }
    }

    protected HierarchicalConfiguration getConfig(SiteContext siteContext, String[] configPaths, ResourceLoader resourceLoader) {
        String siteName = siteContext.getSiteName();
        logger.info((Object)"--------------------------------------------------");
        logger.info((Object)("<Loading configuration for site: " + siteName + ">"));
        logger.info((Object)"--------------------------------------------------");
        try {
            for (int i = configPaths.length - 1; i >= 0; --i) {
                Resource config = resourceLoader.getResource(configPaths[i]);
                if (!config.exists()) continue;
                HierarchicalConfiguration hierarchicalConfiguration = this.configurationReader.readXmlConfiguration(config);
                return hierarchicalConfiguration;
            }
            HierarchicalConfiguration i = null;
            return i;
        }
        catch (ConfigurationException e) {
            throw new SiteContextCreationException("Unable to load configuration for site '" + siteName + "'", e);
        }
        finally {
            logger.info((Object)"--------------------------------------------------");
            logger.info((Object)("</Loading configuration for site: " + siteName + ">"));
            logger.info((Object)"--------------------------------------------------");
        }
    }

    protected void configureScriptSandbox(SiteContext siteContext, ResourceLoader resourceLoader) {
        block16: {
            try {
                if (this.enableScriptSandbox && this.enableSandboxBlacklist) {
                    Resource sandboxBlacklist = resourceLoader.getResource(this.sandboxBlacklist);
                    try (InputStream is = sandboxBlacklist.getInputStream();){
                        Blacklist blacklist = new Blacklist((Reader)new InputStreamReader(is));
                        siteContext.scriptSandbox = new SandboxInterceptor((Whitelist)blacklist, Collections.singletonList(Dom4jExtension.class));
                        break block16;
                    }
                }
                if (this.enableScriptSandbox) {
                    PermitAllWhitelist whitelist = new PermitAllWhitelist();
                    siteContext.scriptSandbox = new SandboxInterceptor((Whitelist)whitelist, Collections.singletonList(Dom4jExtension.class));
                }
            }
            catch (IOException e) {
                throw new SiteContextCreationException("Unable to load sandbox blacklist for site '" + siteContext.getSiteName() + "'", e);
            }
        }
    }

    protected URLClassLoader getClassLoader(SiteContext siteContext) {
        GroovyClassLoader classLoader = new GroovyClassLoader(this.getClass().getClassLoader(), GroovyScriptUtils.getCompilerConfiguration(this.enableScriptSandbox));
        ContentStoreGroovyResourceLoader resourceLoader = new ContentStoreGroovyResourceLoader(siteContext, this.groovyClassesPath);
        classLoader.setResourceLoader((GroovyResourceLoader)resourceLoader);
        return classLoader;
    }

    protected ConfigurableApplicationContext getApplicationContext(SiteContext siteContext, URLClassLoader classLoader, HierarchicalConfiguration config, String[] applicationContextPaths, ResourceLoader resourceLoader) {
        String siteName = siteContext.getSiteName();
        logger.info((Object)"--------------------------------------------------");
        logger.info((Object)("<Loading application context for site: " + siteName + ">"));
        logger.info((Object)"--------------------------------------------------");
        try {
            Resource appContextResource = null;
            for (int i = applicationContextPaths.length - 1; i >= 0; --i) {
                Resource resource = resourceLoader.getResource(applicationContextPaths[i]);
                if (!resource.exists()) continue;
                appContextResource = resource;
                break;
            }
            if (appContextResource != null) {
                Object appContext = this.disableVariableRestrictions ? new GenericApplicationContext(this.globalApplicationContext) : new RestrictedApplicationContext(this.globalApplicationContext, this.defaultPublicBeans);
                appContext.setClassLoader((ClassLoader)classLoader);
                if (!this.enableExpressions) {
                    appContext.addBeanFactoryPostProcessor(factory -> factory.setBeanExpressionResolver(null));
                }
                if (config != null) {
                    MutablePropertySources propertySources = appContext.getEnvironment().getPropertySources();
                    propertySources.addFirst((PropertySource)new ApacheCommonsConfiguration2PropertySource(CONFIG_BEAN_NAME, (Configuration)config));
                    appContext.getBeanFactory().registerSingleton(CONFIG_BEAN_NAME, (Object)config);
                }
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
                reader.setValidationMode(3);
                reader.loadBeanDefinitions(appContextResource);
                appContext.refresh();
                GenericApplicationContext genericApplicationContext = appContext;
                return genericApplicationContext;
            }
            ConfigurableApplicationContext configurableApplicationContext = null;
            return configurableApplicationContext;
        }
        catch (Exception e) {
            throw new SiteContextCreationException("Unable to load application context for site '" + siteName + "'", e);
        }
        finally {
            logger.info((Object)"--------------------------------------------------");
            logger.info((Object)("</Loading application context for site: " + siteName + ">"));
            logger.info((Object)"--------------------------------------------------");
        }
    }

    protected UrlRewriter getUrlRewriter(SiteContext siteContext, String[] urlRewriteConfPaths, ResourceLoader resourceLoader) {
        String siteName = siteContext.getSiteName();
        String confPath = null;
        Resource confResource = null;
        Conf conf = null;
        UrlRewriter urlRewriter = null;
        logger.info((Object)"--------------------------------------------------");
        logger.info((Object)("<Loading URL rewrite engine for site: " + siteName + ">"));
        logger.info((Object)"--------------------------------------------------");
        try {
            for (int i = urlRewriteConfPaths.length - 1; i >= 0; --i) {
                Resource resource = resourceLoader.getResource(urlRewriteConfPaths[i]);
                if (!resource.exists()) continue;
                confPath = urlRewriteConfPaths[i];
                confResource = resource;
                break;
            }
            if (confResource != null) {
                boolean modRewriteStyleConf = !confPath.endsWith(".xml");
                try (InputStream is = confResource.getInputStream();){
                    conf = new Conf(this.servletContext, is, confPath, "", modRewriteStyleConf);
                    logger.info((Object)("URL rewrite configuration loaded @ " + confResource));
                }
            }
            if (conf != null) {
                if (conf.isOk() && conf.isEngineEnabled()) {
                    urlRewriter = new UrlRewriter(conf);
                    logger.info((Object)("URL rewrite engine loaded for site " + siteName + " (conf ok)"));
                } else {
                    logger.error((Object)"URL rewrite engine not loaded, there might have been conf errors");
                }
            }
            UrlRewriter modRewriteStyleConf = urlRewriter;
            return modRewriteStyleConf;
        }
        catch (Exception e) {
            throw new SiteContextCreationException("Unable to load URL rewrite conf for site '" + siteName + "'", e);
        }
        finally {
            logger.info((Object)"--------------------------------------------------");
            logger.info((Object)("</Loading URL rewrite engine for site: " + siteName + ">"));
            logger.info((Object)"--------------------------------------------------");
        }
    }

    protected HierarchicalConfiguration getProxyConfig(SiteContext siteContext, List<String> configPaths, ResourceLoader resourceLoader) {
        String siteName = siteContext.getSiteName();
        logger.info((Object)"-------------------------------------------------------");
        logger.info((Object)("<Loading proxy configuration for site: " + siteName + ">"));
        logger.info((Object)"-------------------------------------------------------");
        try {
            ListIterator<String> iterator = configPaths.listIterator(configPaths.size());
            while (iterator.hasPrevious()) {
                Resource resource = resourceLoader.getResource(iterator.previous());
                if (!resource.exists()) continue;
                HierarchicalConfiguration hierarchicalConfiguration = this.configurationReader.readXmlConfiguration(resource);
                return hierarchicalConfiguration;
            }
            HierarchicalConfiguration hierarchicalConfiguration = null;
            return hierarchicalConfiguration;
        }
        catch (ConfigurationException e) {
            throw new SiteContextCreationException("Unable to load proxy configuration for site '" + siteName + "'", e);
        }
        finally {
            logger.info((Object)"---------------------------------------------------------");
            logger.info((Object)("</Loading proxy configuration for site: " + siteName + ">"));
            logger.info((Object)"---------------------------------------------------------");
        }
    }

    protected ScriptFactory getScriptFactory(SiteContext siteContext, URLClassLoader classLoader) {
        return new GroovyScriptFactory(siteContext, new ContentStoreResourceConnector(siteContext), classLoader, this.groovyGlobalVars, this.enableScriptSandbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler scheduleJobs(SiteContext siteContext) {
        String siteName = siteContext.getSiteName();
        logger.info((Object)"--------------------------------------------------");
        logger.info((Object)("<Scheduling job scripts for site: " + siteName + ">"));
        logger.info((Object)"--------------------------------------------------");
        try {
            ArrayList<JobContext> allJobContexts = new ArrayList<JobContext>();
            for (ScriptJobResolver jobResolver : this.jobResolvers) {
                List<JobContext> jobContexts = jobResolver.resolveJobs(siteContext);
                if (!CollectionUtils.isNotEmpty(jobContexts)) continue;
                allJobContexts.addAll(jobContexts);
            }
            if (CollectionUtils.isNotEmpty(allJobContexts)) {
                Scheduler scheduler = SchedulingUtils.createScheduler(String.format("%s_%s_scheduler", siteName, siteContext.getContext().getId()), this.jobThreadPoolExecutor);
                for (JobContext jobContext : allJobContexts) {
                    scheduler.scheduleJob(jobContext.getDetail(), jobContext.getTrigger());
                    logger.info((Object)("Scheduled job: " + jobContext + " for site '" + siteName + "'"));
                }
                scheduler.start();
                Scheduler scheduler2 = scheduler;
                return scheduler2;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to schedule jobs for site '" + siteName + "'"), (Throwable)e);
        }
        finally {
            logger.info((Object)"--------------------------------------------------");
            logger.info((Object)("</Scheduling job scripts for site: " + siteName + ">"));
            logger.info((Object)"--------------------------------------------------");
        }
        return null;
    }
}

