/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.concurrent.locks.KeyBasedLockFactory;
import org.craftercms.commons.concurrent.locks.WeakKeyBasedReentrantLockFactory;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextFactory;
import org.craftercms.engine.service.context.SiteListResolver;
import org.springframework.beans.factory.annotation.Required;

public class SiteContextManager {
    private static final Log logger = LogFactory.getLog(SiteContextManager.class);
    protected KeyBasedLockFactory<ReentrantLock> siteLockFactory = new WeakKeyBasedReentrantLockFactory();
    protected Map<String, SiteContext> contextRegistry = new ConcurrentHashMap<String, SiteContext>();
    protected SiteContextFactory contextFactory;
    protected SiteContextFactory fallbackContextFactory;
    protected SiteListResolver siteListResolver;
    protected EntitlementValidator entitlementValidator;
    protected boolean waitForContextInit;
    protected Executor jobThreadPoolExecutor;
    protected String defaultSiteName;

    @Required
    public void setContextFactory(SiteContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Required
    public void setFallbackContextFactory(SiteContextFactory fallbackContextFactory) {
        this.fallbackContextFactory = fallbackContextFactory;
    }

    @Required
    public void setSiteListResolver(SiteListResolver siteListResolver) {
        this.siteListResolver = siteListResolver;
    }

    @Required
    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }

    @Required
    public void setWaitForContextInit(boolean waitForContextInit) {
        this.waitForContextInit = waitForContextInit;
    }

    @Required
    public void setJobThreadPoolExecutor(Executor jobThreadPoolExecutor) {
        this.jobThreadPoolExecutor = jobThreadPoolExecutor;
    }

    @Required
    public void setDefaultSiteName(String defaultSiteName) {
        this.defaultSiteName = defaultSiteName;
    }

    @PreDestroy
    public void destroy() {
        this.destroyAllContexts();
    }

    public Collection<SiteContext> listContexts() {
        return this.contextRegistry.values();
    }

    public void createContexts(boolean concurrent) {
        Collection<String> siteNames = this.siteListResolver.getSiteList();
        logger.info((Object)"==================================================");
        logger.info((Object)"<CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            if (concurrent) {
                ExecutorCompletionService<SiteContext> cs = new ExecutorCompletionService<SiteContext>(this.jobThreadPoolExecutor);
                for (String siteName : siteNames) {
                    cs.submit(() -> {
                        try {
                            return this.getContext(siteName, false);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error creating site context for site '" + siteName + "'"), (Throwable)e);
                            return null;
                        }
                    });
                }
                for (int i = 0; i < siteNames.size(); ++i) {
                    try {
                        cs.take();
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Stopping creation of site contexts, thread interrupted");
                        return;
                    }
                }
            } else {
                for (String siteName : siteNames) {
                    try {
                        this.getContext(siteName, false);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error creating site context for site '" + siteName + "'"), (Throwable)e);
                    }
                }
            }
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    public void syncContexts() {
        logger.debug((Object)"Syncing the site contexts ...");
        Collection<String> siteNames = this.siteListResolver.getSiteList();
        this.contextRegistry.forEach((siteName, siteContext) -> {
            if (!siteContext.isFallback() && !siteNames.contains(siteName)) {
                try {
                    this.destroyContext((String)siteName);
                }
                catch (Exception e) {
                    logger.error((Object)("Error destroying site context for site '" + siteName + "'"), (Throwable)e);
                }
            }
        });
        siteNames.forEach(siteName -> {
            try {
                this.getContext((String)siteName, false);
            }
            catch (Exception e) {
                logger.error((Object)("Error creating site context for site '" + siteName + "'"), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllContexts() {
        logger.info((Object)"==================================================");
        logger.info((Object)"<DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        Iterator<SiteContext> iter = this.contextRegistry.values().iterator();
        while (iter.hasNext()) {
            SiteContext siteContext = iter.next();
            String siteName = siteContext.getSiteName();
            logger.info((Object)"==================================================");
            logger.info((Object)("<Destroying site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
            Lock lock = (Lock)this.siteLockFactory.getLock((Object)siteName);
            lock.lock();
            try {
                this.destroyContext(siteContext);
            }
            catch (Exception e) {
                logger.error((Object)("Error destroying site context for site '" + siteName + "'"), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
            logger.info((Object)"==================================================");
            logger.info((Object)("</Destroying site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
            iter.remove();
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SiteContext getContext(String siteName, boolean fallback) {
        SiteContext siteContext = this.contextRegistry.get(siteName);
        if (siteContext == null) {
            if (!(fallback || siteName.equals(this.defaultSiteName) || this.validateSiteCreationEntitlement())) {
                return null;
            }
            Lock lock = (Lock)this.siteLockFactory.getLock((Object)siteName);
            lock.lock();
            try {
                siteContext = this.contextRegistry.get(siteName);
                if (siteContext != null) return siteContext;
                logger.info((Object)"==================================================");
                logger.info((Object)("<Creating site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                siteContext = this.createContext(siteName, fallback);
                logger.info((Object)"==================================================");
                logger.info((Object)("</Creating site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                return siteContext;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (siteContext.isValid()) return siteContext;
            logger.error((Object)("Site context " + siteContext + " is not valid anymore"));
            this.destroyContext(siteName);
            return null;
        }
    }

    public void startContextRebuild(String siteName, boolean fallback) {
        this.jobThreadPoolExecutor.execute(() -> this.rebuildContext(siteName, fallback));
    }

    public void startDestroyContext(String siteName) {
        this.jobThreadPoolExecutor.execute(() -> this.destroyContext(siteName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyContext(String siteName) {
        SiteContext siteContext;
        Lock lock = (Lock)this.siteLockFactory.getLock((Object)siteName);
        lock.lock();
        try {
            siteContext = this.contextRegistry.remove(siteName);
        }
        finally {
            lock.unlock();
        }
        if (siteContext != null) {
            logger.info((Object)"==================================================");
            logger.info((Object)("<Destroying site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
            this.destroyContext(siteContext);
            logger.info((Object)"==================================================");
            logger.info((Object)("</Destroying site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
        }
    }

    protected void destroyContexts(Collection<String> siteNames) {
        logger.info((Object)"==================================================");
        logger.info((Object)"<DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            for (String siteName : siteNames) {
                try {
                    this.destroyContext(siteName);
                }
                catch (Exception e) {
                    logger.error((Object)("Error destroying site context for site '" + siteName + "'"), (Throwable)e);
                }
            }
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    protected SiteContext createContext(String siteName, boolean fallback) {
        SiteContext siteContext;
        if (fallback) {
            siteContext = this.fallbackContextFactory.createContext(siteName);
            siteContext.setFallback(true);
        } else {
            siteContext = this.contextFactory.createContext(siteName);
        }
        siteContext.init(this.waitForContextInit);
        this.contextRegistry.put(siteName, siteContext);
        logger.info((Object)("Site context created: " + siteContext));
        return siteContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildContext(String siteName, boolean fallback) {
        Lock lock = (Lock)this.siteLockFactory.getLock((Object)siteName);
        lock.lock();
        try {
            logger.info((Object)"==================================================");
            logger.info((Object)("<Rebuilding site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
            SiteContext oldSiteContext = this.contextRegistry.get(siteName);
            this.createContext(siteName, fallback);
            oldSiteContext.destroy();
            logger.info((Object)"==================================================");
            logger.info((Object)("</Rebuilding site context: " + siteName + ">"));
            logger.info((Object)"==================================================");
        }
        finally {
            lock.unlock();
        }
    }

    protected void destroyContext(SiteContext siteContext) {
        siteContext.destroy();
        logger.info((Object)("Site context destroyed: " + siteContext));
    }

    protected boolean validateSiteCreationEntitlement() {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.SITE, 1);
            return true;
        }
        catch (EntitlementException e) {
            return false;
        }
    }
}

