/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.filter;

import java.util.Arrays;
import java.util.List;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class ExcludeByNameItemFilter
implements ItemFilter {
    private String[] excludeRegexes;

    public ExcludeByNameItemFilter(String excludeRegex) {
        this.excludeRegexes = new String[1];
        this.excludeRegexes[0] = excludeRegex;
    }

    public ExcludeByNameItemFilter(String[] excludeRegexes) {
        this.excludeRegexes = excludeRegexes;
    }

    public boolean runBeforeProcessing() {
        return true;
    }

    public boolean runAfterProcessing() {
        return false;
    }

    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        for (String regex : this.excludeRegexes) {
            if (!item.getName().matches(regex)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ExcludeByNameItemFilter[excludeRegexes=" + (this.excludeRegexes == null ? null : Arrays.asList(this.excludeRegexes)) + ']';
    }
}

