/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.filter;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class ExpectedNodeValueItemFilter
implements ItemFilter {
    private String nodeXPathQuery;
    private String expectedValueRegex;

    public ExpectedNodeValueItemFilter(String nodeXPathQuery, String expectedValueRegex) {
        this.nodeXPathQuery = nodeXPathQuery;
        this.expectedValueRegex = expectedValueRegex;
    }

    public boolean runBeforeProcessing() {
        return false;
    }

    public boolean runAfterProcessing() {
        return true;
    }

    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        if (item.getDescriptorDom() != null) {
            String result = item.queryDescriptorValue(this.nodeXPathQuery);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                return result.matches(this.expectedValueRegex);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "ExpectedNodeValueItemFilter[nodeXPathQuery='" + this.nodeXPathQuery + '\'' + ", expectedValueRegex='" + this.expectedValueRegex + '\'' + ']';
    }
}

