/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

public class ConfigAwareEtagFilter
extends ShallowEtagHeaderFilter {
    protected boolean enabled;
    protected String[] includedUrls;
    protected PathMatcher pathMatcher;

    public ConfigAwareEtagFilter(boolean enabled, String[] includedUrls) {
        this.enabled = enabled;
        this.includedUrls = includedUrls;
        this.pathMatcher = new AntPathMatcher();
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return !this.enabled || Stream.of(this.includedUrls).noneMatch(url -> this.pathMatcher.match(url, request.getRequestURI())) || super.shouldNotFilter(request);
    }
}

