/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class ContentCachingFilter
extends OncePerRequestFilter {
    protected boolean enabled;

    public ContentCachingFilter(boolean enabled) {
        this.enabled = enabled;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return !this.enabled || !HttpMethod.POST.matches(request.getMethod()) || !StringUtils.equalsIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"application/x-www-form-urlencoded");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)new ContentCachingRequestWrapper(request), (ServletResponse)response);
    }
}

