/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.engine.exception.proxy.HttpProxyException;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.servlet.ConfigAwareProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.mvc.Controller;

public class HttpProxyFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxyFilter.class);
    public static final String CONFIG_KEY_SERVERS = "servers.server";
    public static final String CONFIG_KEY_PATTERNS = "patterns.pattern";
    public static final String CONFIG_KEY_ID = "id";
    public static final String CONFIG_KEY_URL = "url";
    protected boolean enabled;
    protected Controller proxyController;
    protected RequestMatcher excludedMatcher;

    public HttpProxyFilter(boolean enabled, Controller proxyController, String[] excludedUrls) {
        this.enabled = enabled;
        this.proxyController = proxyController;
        this.excludedMatcher = new OrRequestMatcher(Stream.of(excludedUrls).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return !this.enabled || this.excludedMatcher.matches(request);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        logger.debug("Trying to execute proxy request for {}", (Object)request.getRequestURI());
        try {
            String requestUri = request.getRequestURI();
            String targetUrl = this.getTargetUrl(SiteContext.getCurrent(), request.getRequestURI());
            if (!StringUtils.isEmpty((String)targetUrl) && !request.getRequestURL().toString().contains(targetUrl)) {
                logger.debug("Resolved target url {} for proxy request {}", (Object)targetUrl, (Object)requestUri);
                request.setAttribute(ConfigAwareProxyServlet.ATTR_TARGET_URI, (Object)targetUrl);
                request.setAttribute(ConfigAwareProxyServlet.ATTR_TARGET_HOST, (Object)URIUtils.extractHost((URI)URI.create(targetUrl)));
                logger.debug("Starting execution of proxy request for {}", (Object)requestUri);
                this.proxyController.handleRequest(request, response);
                return;
            }
            logger.debug("Resolved target url for request {} is local, will skip proxy", (Object)requestUri);
        }
        catch (HttpProxyException e) {
            logger.debug("Continue with local execution for request " + request.getRequestURI(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new ServletException("Error executing proxy request for " + request.getRequestURI(), (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getTargetUrl(SiteContext siteContext, String requestUri) {
        HierarchicalConfiguration proxyConfig = siteContext.getProxyConfig();
        if (proxyConfig == null) {
            throw new HttpProxyException("No proxy configuration found for site " + siteContext.getSiteName());
        }
        List servers = proxyConfig.configurationsAt(CONFIG_KEY_SERVERS);
        for (HierarchicalConfiguration server : servers) {
            List patterns = server.getList(String.class, CONFIG_KEY_PATTERNS);
            if (!RegexUtils.matchesAny((String)requestUri, (List)patterns)) continue;
            logger.debug("Found matching server '{}' for proxy request {}", (Object)server.getString(CONFIG_KEY_ID), (Object)requestUri);
            return server.getString(CONFIG_KEY_URL, null);
        }
        return null;
    }
}

