/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateHashModelEx;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SiteContextResolvingFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SiteContextResolvingFilter.class);
    protected String errorTemplate;
    protected SiteContextResolver contextResolver;
    protected ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory;

    @Required
    public void setErrorTemplate(String errorTemplate) {
        this.errorTemplate = errorTemplate;
    }

    @Required
    public void setContextResolver(SiteContextResolver contextResolver) {
        this.contextResolver = contextResolver;
    }

    @Required
    public void setFreeMarkerConfigFactory(ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory) {
        this.freeMarkerConfigFactory = freeMarkerConfigFactory;
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SiteContext siteContext = this.getContext((HttpServletRequest)request);
        if (siteContext == null) {
            this.renderError((HttpServletResponse)response);
            return;
        }
        SiteContext.setCurrent(siteContext);
        try {
            chain.doFilter(request, response);
        }
        finally {
            SiteContext.clear();
        }
    }

    protected SiteContext getContext(HttpServletRequest request) {
        try {
            return this.contextResolver.getContext(request);
        }
        catch (Exception e) {
            logger.error("Error while resolving site context for current request", (Throwable)e);
            return null;
        }
    }

    protected void renderError(HttpServletResponse response) {
        response.setStatus(500);
        try {
            Configuration configuration = ((FreeMarkerConfig)this.freeMarkerConfigFactory.getObject()).getConfiguration();
            Template template = configuration.getTemplate(this.errorTemplate);
            SimpleHash model = new SimpleHash(configuration.getObjectWrapper());
            configuration.setAllSharedVariables((TemplateHashModelEx)model);
            template.process((Object)model, (Writer)response.getWriter());
        }
        catch (Exception e) {
            logger.error("Error rendering template for site resolving error", (Throwable)e);
        }
    }

    public void destroy() {
    }
}

