/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.interceptor;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SiteCookieChangeInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(SiteCookieChangeInterceptor.class);
    protected boolean enabled;
    protected String cookieName;
    protected String cookieDomain;
    protected String cookiePath;
    protected int cookieMaxAge;
    protected boolean httpOnly;
    protected boolean secure;

    public SiteCookieChangeInterceptor(boolean enabled, String cookieName, String cookieDomain, String cookiePath, int cookieMaxAge, boolean httpOnly, boolean secure) {
        this.enabled = enabled;
        this.cookieName = cookieName;
        this.cookieDomain = cookieDomain;
        this.cookiePath = cookiePath;
        this.cookieMaxAge = cookieMaxAge;
        this.httpOnly = httpOnly;
        this.secure = secure;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (!this.enabled) {
            return;
        }
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            String cookieValue;
            String siteName = siteContext.getSiteName();
            if (!siteName.equals(cookieValue = HttpUtils.getCookieValue((String)this.cookieName, (HttpServletRequest)request))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting '" + this.cookieName + "' cookie to '" + siteName + "'"));
                }
                Cookie cookie = new Cookie(this.cookieName, siteName);
                if (StringUtils.isEmpty((CharSequence)this.cookieDomain)) {
                    cookie.setDomain(request.getServerName());
                } else {
                    cookie.setDomain(this.cookieDomain);
                }
                cookie.setPath(this.cookiePath);
                cookie.setMaxAge(this.cookieMaxAge);
                cookie.setHttpOnly(this.httpOnly);
                cookie.setSecure(this.secure);
                response.addCookie(cookie);
            }
        } else {
            throw new IllegalStateException("No current site context found");
        }
    }
}

