/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.store;

import java.util.List;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.impl.AbstractFileBasedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.cache.impl.CachingAwareList;

public abstract class AbstractCachedFileBasedContentStoreAdapter
extends AbstractFileBasedContentStoreAdapter {
    public static final String CONST_KEY_ELEM_FILE = "fileBasedContentStoreAdapter.file";
    public static final String CONST_KEY_ELEM_CHILDREN = "fileBasedContentStoreAdapter.children";

    protected File findFile(final Context context, CachingOptions cachingOptions, final String path) throws InvalidContextException, StoreException {
        CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return (File)this.cacheTemplate.getObject(context, actualCachingOptions, (Callback)new Callback<File>(){

            public File execute() {
                return AbstractCachedFileBasedContentStoreAdapter.this.doFindFile(context, path);
            }

            public String toString() {
                return String.format(((Object)((Object)AbstractCachedFileBasedContentStoreAdapter.this)).getClass().getName() + ".findFile(%s, %s)", context, path);
            }
        }, new Object[]{path, CONST_KEY_ELEM_FILE});
    }

    protected List<File> getChildren(final Context context, CachingOptions cachingOptions, final File dir) throws InvalidContextException, StoreException {
        CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return (List)this.cacheTemplate.getObject(context, actualCachingOptions, (Callback)new Callback<List<File>>(){

            public List<File> execute() {
                List<File> children = AbstractCachedFileBasedContentStoreAdapter.this.doGetChildren(context, dir);
                if (children != null) {
                    if (children instanceof CachingAwareList) {
                        return children;
                    }
                    return new CachingAwareList(children);
                }
                return null;
            }

            public String toString() {
                return String.format(((Object)((Object)AbstractCachedFileBasedContentStoreAdapter.this)).getClass().getName() + ".getChildren(%s, %s)", context, dir);
            }
        }, new Object[]{dir, CONST_KEY_ELEM_CHILDREN});
    }

    protected abstract File doFindFile(Context var1, String var2) throws InvalidContextException, StoreException;

    protected abstract List<File> doGetChildren(Context var1, File var2) throws InvalidContextException, StoreException;
}

